/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class WinEn
implements EventsInterface,
ActionListener {
    private FacileApp fapp;
    private MainThread fth;
    private JFrame frmFacileWinEN;
    private JButton btnAvanti;
    private JButton btnHome;
    private JButton btnEsci;
    private JButton btnIndietro;
    private JPanel pnlTab;
    private IntroWnd pnlIntroWnd;
    private ConnectionTypeWnd pnlConnType;
    private ConnectionMode pnlConnMode;
    private CommPortSelection pnlCommPortSelection;
    private LoadTest pnlLoadTest;
    private Measurement pnlMeasurement;
    private Settings pnlSettings;
    private MenuSaveSend pnlMenuSaveSend;
    private JMenuItem mntmChangeLanguage;
    private PagesEnum currPage;
    private Timer tmr;
    private boolean mbOpened = false;
    HoldingValues objHV = new HoldingValues();
    private JMenuItem mntmQuit;

    public WinEn(FacileApp fa, MainThread wth) {
        this.fapp = fa;
        this.fth = wth;
        this.initialize();
    }

    private void initialize() {
        this.frmFacileWinEN = new JFrame();
        this.frmFacileWinEN.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WinEn.this.exitFromApp();
            }
        });
        this.frmFacileWinEN.setResizable(false);
        this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 1.1.2");
        this.frmFacileWinEN.setSize(new Dimension(800, 600));
        this.frmFacileWinEN.setBounds(100, 100, 800, 600);
        this.frmFacileWinEN.setDefaultCloseOperation(3);
        this.frmFacileWinEN.getContentPane().setLayout(null);
        this.pnlTab = new JPanel();
        this.pnlTab.setName("PANEL1");
        this.pnlTab.setBackground(new Color(72, 209, 204));
        this.pnlTab.setBounds(10, 11, 774, 485);
        this.frmFacileWinEN.getContentPane().add(this.pnlTab);
        this.pnlTab.setLayout(null);
        this.btnAvanti = new JButton(FacileParam.loadLanguage("btnAvanti"));
        this.btnAvanti.addActionListener(this);
        this.btnAvanti.setCursor(Cursor.getPredefinedCursor(12));
        this.btnAvanti.setBounds(440, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnAvanti);
        this.btnHome = new JButton(FacileParam.loadLanguage("btnHome"));
        this.btnHome.addActionListener(this);
        this.btnHome.setCursor(Cursor.getPredefinedCursor(12));
        this.btnHome.setBounds(10, 500, 163, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnHome);
        this.btnIndietro = new JButton(FacileParam.loadLanguage("btnIndietro"));
        this.btnIndietro.addActionListener(this);
        this.btnIndietro.setCursor(Cursor.getPredefinedCursor(12));
        this.btnIndietro.setBounds(258, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnIndietro);
        this.btnEsci = new JButton(FacileParam.loadLanguage("btnEsci"));
        this.btnEsci.addActionListener(this);
        this.btnEsci.setCursor(Cursor.getPredefinedCursor(12));
        this.btnEsci.setBounds(679, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnEsci);
        this.pnlIntroWnd = new IntroWnd();
        this.pnlIntroWnd.setLocation(0, 0);
        this.pnlIntroWnd.setSize(774, 485);
        this.pnlIntroWnd.setEventHandler(this);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBackground(SystemColor.menu);
        menuBar.setFont(new Font("Segoe UI", 1, 12));
        this.frmFacileWinEN.setJMenuBar(menuBar);
        JMenu mnActions = new JMenu(FacileParam.loadLanguage("mnActions"));
        menuBar.add(mnActions);
        this.mntmChangeLanguage = new JMenuItem(FacileParam.loadLanguage("mntmChangeLanguage"));
        this.mntmChangeLanguage.addActionListener(this);
        mnActions.add(this.mntmChangeLanguage);
        this.mntmQuit = new JMenuItem(FacileParam.loadLanguage("mntmQuit"));
        this.mntmQuit.addActionListener(this);
        mnActions.add(this.mntmQuit);
        this.pnlConnType = new ConnectionTypeWnd();
        this.pnlConnType.setEventHandler(this);
        this.pnlConnMode = new ConnectionMode();
        this.pnlConnMode.setEventHandler(this);
        this.pnlCommPortSelection = new CommPortSelection();
        this.pnlCommPortSelection.setEventHandler(this);
        this.pnlLoadTest = new LoadTest();
        this.pnlLoadTest.setEventHandler(this);
        this.pnlMeasurement = new Measurement(this.fapp, this.frmFacileWinEN);
        this.pnlMeasurement.setEventHandler(this);
        this.pnlSettings = new Settings();
        this.pnlSettings.setEventHandler(this);
        this.pnlMenuSaveSend = new MenuSaveSend();
        this.pnlMenuSaveSend.setEventHandler(this);
        this.fapp.ultimaPaginaValida = false;
        this.tmr = new Timer(100, this);
        this.setPageIntro();
    }

    public void facileShow() {
        this.frmFacileWinEN.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnHome) {
            this.fapp.isOffline = true;
            this.fapp.modbus_close();
            this.endTestTimer();
            this.setPageIntro();
        } else if (e.getSource() == this.btnAvanti) {
            if (this.currPage == PagesEnum.Intro) {
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.ConnectionMode) {
                this.setCommPortSelection();
            } else if (this.currPage == PagesEnum.CommPortSelection) {
                this.setLoadTest();
            } else if (this.currPage == PagesEnum.Settings) {
                this.setMenuSaveSendTest();
            }
        } else if (e.getSource() == this.btnEsci) {
            this.exitFromApp();
        } else if (e.getSource() == this.btnIndietro) {
            if (this.currPage == PagesEnum.ConnectionTypeWnd) {
                this.setPageIntro();
            } else if (this.currPage == PagesEnum.ConnectionMode) {
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.LoadTest) {
                if (this.fapp.isOffline) {
                    this.setConnectionType();
                } else {
                    this.setCommPortSelection();
                }
            } else if (this.currPage == PagesEnum.Settings) {
                this.setLoadTest();
            } else if (this.currPage == PagesEnum.CommPortSelection) {
                this.setPageConnectionMode();
            } else if (this.currPage == PagesEnum.MeasurementWnd) {
                this.fapp.isOffline = true;
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.MenuSaveSend) {
                this.setSettingsPage();
            }
        } else if (e.getSource() == this.mntmChangeLanguage) {
            FacileLangEN fd = new FacileLangEN();
            fd.showCentered(this.frmFacileWinEN.getBounds());
            fd.setVisible(true);
            if (fd.isOk()) {
                this.endTestTimer();
                this.fapp.lang = fd.getLang();
                this.fapp.saveAppIni();
                this.frmFacileWinEN.setVisible(false);
                this.frmFacileWinEN.dispose();
                this.fth.ended = false;
                this.fth.changeLang = true;
            }
            fd.dispose();
        } else if (e.getSource() == this.mntmQuit) {
            this.quitApplication();
        } else {
            this.tmr.stop();
            if (this.currPage == PagesEnum.MeasurementWnd) {
                this.readTestFromDev();
                this.tmr.start();
            }
        }
    }

    @Override
    public void executeEvent(EventsEnum ev) {
        if (ev == EventsEnum.FacileEvCfg) {
            this.setConnectionType();
        } else if (ev == EventsEnum.FacileEvOffline) {
            this.fapp.isOffline = true;
            this.setLoadTest();
        } else if (ev == EventsEnum.FacileEvUSB) {
            this.setPageConnectionMode();
        } else if (ev == EventsEnum.StartConnManually) {
            this.startConnectingToDevice();
            this.pnlSettings = new Settings();
            this.pnlSettings.setEventHandler(this);
        } else if (ev == EventsEnum.UpdateCommPorts) {
            this.updateCommPorts();
        } else if (ev == EventsEnum.FacileEvTest) {
            this.setMeasPage();
        } else if (ev == EventsEnum.FacileEvCfgDefault) {
            this.pnlSettings.defaultPage();
            this.setSettingsPage();
        } else if (ev == EventsEnum.FacileEvLoadDev) {
            if (this.readCfgFromDev()) {
                this.setSettingsPage();
            }
        } else if (ev == EventsEnum.FacileEvSendDev) {
            if (this.sendCfgToDev()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.startConnectingToDeviceNewParameters();
                this.setMeasPage();
            }
        } else if (ev == EventsEnum.FacileEvSaveFile) {
            this.saveSettingsFile();
        } else if (ev == EventsEnum.FacileEvLoadFile) {
            this.loadSettingsFile();
        } else if (ev == EventsEnum.FacileEvGoCfgStart) {
            this.setLoadTest();
        }
    }

    protected void setFacilePage(PagesEnum p, Component c) {
        this.fapp.ultimaPagina = this.currPage;
        this.fapp.ultimaPaginaValida = true;
        this.currPage = p;
        this.pnlTab.removeAll();
        this.pnlTab.add(c);
        this.pnlTab.repaint();
        this.pnlTab.setVisible(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pnlTab.setVisible(true);
    }

    protected void setPageIntro() {
        this.setFacilePage(PagesEnum.Intro, this.pnlIntroWnd);
        this.btnHome.setEnabled(false);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(false);
        this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 1.1.2");
    }

    protected void setConnectionType() {
        this.setFacilePage(PagesEnum.ConnectionTypeWnd, this.pnlConnType);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setPageConnectionMode() {
        this.setFacilePage(PagesEnum.ConnectionMode, this.pnlConnMode);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacileCommPortSelection() {
        this.setFacilePage(PagesEnum.ConnectionMode, this.pnlConnMode);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setMeasPage() {
        this.setFacilePage(PagesEnum.MeasurementWnd, this.pnlMeasurement);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
        this.tmr.setInitialDelay(5);
        this.tmr.setDelay(10);
        this.tmr.setRepeats(false);
        this.tmr.start();
    }

    protected void setCommPortSelection() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.pnlCommPortSelection.setSerialPorts(coms);
        this.setFacilePage(PagesEnum.CommPortSelection, this.pnlCommPortSelection);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setLoadTest() {
        this.pnlLoadTest.setOffline(this.fapp.isOffline);
        this.setFacilePage(PagesEnum.LoadTest, this.pnlLoadTest);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setSettingsPage() {
        this.pnlSettings.initSettings();
        this.setFacilePage(PagesEnum.Settings, this.pnlSettings);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setMenuSaveSendTest() {
        this.pnlMenuSaveSend.setOffline(this.fapp.isOffline);
        this.setFacilePage(PagesEnum.MenuSaveSend, this.pnlMenuSaveSend);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void updateCommPorts() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.pnlCommPortSelection.setSerialPorts(coms);
    }

    private void startConnectingToDevice() {
        Object[] options = new Object[]{FacileParam.loadLanguage("btnContinue")};
        String com = this.pnlCommPortSelection.getSelectedComPort();
        System.out.println("Odabrani COM port:" + com);
        this.fapp.modbusAddr = 1;
        this.fapp.comBaud = 3;
        this.fapp.comParity = 0;
        this.fapp.qiDelay = 1;
        if (this.fapp.checkConnected(com)) {
            if (this.fapp.fw_read == -1) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxConnErrorText"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options, options[0]);
            } else if (this.fapp.fw_read >= 0 && this.fapp.fw_read <= 768) {
                this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 0.1.1 " + Params.appFirmware + " " + FacileParam.loadLanguage("MachineIDTitle") + Params.machineID);
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxConnOK"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options, options[0]);
                this.setLoadTest();
            } else {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, String.format(FacileParam.loadLanguage("msgBoxIncompatabile"), this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10), FacileParam.loadLanguage("APPNAME"), 0, 2, null, options, options[0]);
            }
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxNoConn"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options, options[0]);
            this.fapp.modbus_close();
        }
    }

    private void quitApplication() {
        Object[] options = new Object[]{FacileParam.loadLanguage("msgBoxBtnYES"), FacileParam.loadLanguage("msgBoxBtnNO")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxExitAPP"), FacileParam.loadLanguage("APPNAME"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
            this.fth.changeLang = false;
        }
    }

    private void endTestTimer() {
        this.tmr.stop();
        if (this.mbOpened) {
            this.fapp.modbus_close();
            this.mbOpened = false;
        }
    }

    private boolean readTestFromDev() {
        boolean ok;
        block24: {
            ok = false;
            try {
                byte[] reply = null;
                Object[] options3 = new Object[]{FacileParam.loadLanguage("btnContinue")};
                ok = false;
                if (this.mbOpened) {
                    ok = true;
                } else if (this.fapp.modbus_open()) {
                    this.mbOpened = true;
                    ok = true;
                }
                if (!ok) break block24;
                int[] baudRate = null;
                baudRate = this.fapp.modbus_read_holding_register(4, 1);
                this.fapp.comBaud = baudRate[0];
                int[] parity = null;
                parity = this.fapp.modbus_read_holding_register(5, 1);
                this.fapp.comParity = parity[0];
                int[] values1_32 = null;
                values1_32 = this.fapp.modbus_read_holding_register(160, 64);
                int[] values2_32 = null;
                values2_32 = this.fapp.modbus_read_holding_register(224, 64);
                int[] current1 = null;
                current1 = this.fapp.modbus_read_holding_register(146, 14);
                int[] current2 = null;
                current2 = this.fapp.modbus_read_holding_register(298, 30);
                int[] temperature = null;
                temperature = this.fapp.modbus_read_holding_register(288, 10);
                int[] alarm = null;
                int[] alarmstate = new int[2];
                alarm = this.fapp.modbus_read_holding_register(146, 1);
                alarmstate[0] = (alarm[0] & 0x80) / 128;
                alarmstate[1] = (alarm[0] & 0x4000) / 16384;
                int[] serialNumber = null;
                serialNumber = this.fapp.modbus_read_holding_register(108, 3);
                this.pnlMeasurement.setValues(values1_32, values2_32, current1, current2, temperature, alarmstate);
                this.pnlMeasurement.avanzamento();
                if (values1_32 == null || values2_32 == null) break block24;
                try {
                    this.pnlMeasurement.setCommString(String.valueOf(this.fapp.getBaudString()) + " Baud, " + this.fapp.getStopBitsString() + " Stopbit, " + this.fapp.getParityString() + "- File TAR:" + serialNumber[0] + serialNumber[1] + serialNumber[2]);
                    this.pnlMeasurement.colorReadingBoxes();
                    int[] values = null;
                    if (this.pnlMeasurement.getWritePending() == 1) {
                        int m = this.pnlMeasurement.getWriteSource();
                        float v = this.pnlMeasurement.getWriteValue();
                        this.pnlMeasurement.resetWritePending();
                        values = new int[2];
                        this.fapp.float_to_modbus_lsw(values, 0, v);
                        if (m == 1) {
                            reply = this.fapp.modbus_write_multiple_register(298, values);
                            if (reply != null) {
                                ok = true;
                            }
                        } else if (m == 2) {
                            reply = this.fapp.modbus_write_multiple_register(300, values);
                            if (reply != null) {
                                ok = true;
                            }
                        } else if (m == 3) {
                            reply = this.fapp.modbus_write_multiple_register(302, values);
                            if (reply != null) {
                                ok = true;
                            }
                        } else if (m == 4 && (reply = this.fapp.modbus_write_multiple_register(304, values)) != null) {
                            ok = true;
                        }
                        if (m == 5 && (reply = this.fapp.modbus_write_multiple_register(306, values)) != null) {
                            ok = true;
                        }
                        if (m == 6 && (reply = this.fapp.modbus_write_multiple_register(308, values)) != null) {
                            ok = true;
                        }
                        if (m == 7 && (reply = this.fapp.modbus_write_multiple_register(310, values)) != null) {
                            ok = true;
                        }
                        if (m == 8 && (reply = this.fapp.modbus_write_multiple_register(312, values)) != null) {
                            ok = true;
                        }
                        if (m == 9 && (reply = this.fapp.modbus_write_multiple_register(314, values)) != null) {
                            ok = true;
                        }
                        if (m == 10 && (reply = this.fapp.modbus_write_multiple_register(324, values)) != null) {
                            ok = true;
                        }
                        break block24;
                    }
                    ok = true;
                }
                catch (Exception exception) {}
            }
            catch (NullPointerException ex) {
                ok = false;
            }
        }
        return ok;
    }

    private void startConnectingToDeviceNewParameters() {
        Object[] options = new Object[]{FacileParam.loadLanguage("btnContinue")};
        String com = this.pnlCommPortSelection.getSelectedComPort();
        System.out.println("Odabrani COM port:" + com);
        this.fapp.modbusAddr = Params.mbAddr;
        this.fapp.comBaud = Params.mbBaud;
        this.fapp.comParity = Params.mbParity;
        this.fapp.qiDelay = Params.mbDelay;
    }

    private boolean sendCfgToDev() {
        boolean ok = false;
        byte[] reply = null;
        if (this.fapp.modbus_open()) {
            int[] modbus = new int[]{Params.mbAddr, Params.mbDelay, Params.mbBaud, Params.mbParity};
            this.fapp.modbus_write_single_register(2, modbus[0]);
            this.fapp.modbus_write_single_register(3, modbus[1]);
            this.fapp.modbus_write_single_register(4, modbus[2]);
            this.fapp.modbus_write_single_register(5, modbus[3]);
            int[] values = null;
            values = new int[]{Params.energySaving * 1 + Params.measChannel * 2 + Params.PT100meas * 8 + Params.outputType * 16 + Params.outputMeasRetrans * 32 + Params.FFTrepres * 128 + Params.THDcalc * 256 + Params.tempSensor * 512 + Params.measType * 2048 + Params.integrator * 8192 + Params.digitalOutput * 16384 + Params.filteredMeasurement * 32768};
            reply = this.fapp.modbus_write_multiple_register(6, values);
            System.out.println("Digital output: " + Params.digitalOutput);
            if (reply != null) {
                values = new int[2];
                this.fapp.float_to_modbus_lsw(values, 0, Params.transdRatio);
                reply = this.fapp.modbus_write_multiple_register(8, values);
                if (reply != null) {
                    values = new int[2];
                    this.fapp.float_to_modbus_lsw(values, 0, Params.minimumCurrentStartup);
                    reply = this.fapp.modbus_write_multiple_register(10, values);
                    if (reply != null && (reply = this.fapp.modbus_write_multiple_register(12, values = new int[]{Params.filtDC, Params.numOfZX})) != null && (reply = this.fapp.modbus_write_multiple_register(14, values = new int[]{Params.secMeanRMS, Params.secMaxRMS})) != null && (reply = this.fapp.modbus_write_multiple_register(16, values = new int[]{Params.secMinRMS, Params.secMeanDC})) != null && (reply = this.fapp.modbus_write_multiple_register(18, values = new int[]{Params.secMaxDC, Params.secMinDC})) != null && (reply = this.fapp.modbus_write_multiple_register(20, values = new int[]{Params.secMeanAC, Params.secMaxAC})) != null && (reply = this.fapp.modbus_write_single_register(22, (values = new int[]{Params.secMinAC})[0])) != null) {
                        values = new int[2];
                        this.fapp.float_to_modbus_lsw(values, 0, Params.SteinHart_A);
                        reply = this.fapp.modbus_write_multiple_register(32, values);
                        if (reply != null) {
                            values = new int[2];
                            this.fapp.float_to_modbus_lsw(values, 0, Params.SteinHart_B);
                            reply = this.fapp.modbus_write_multiple_register(34, values);
                            if (reply != null) {
                                values = new int[2];
                                this.fapp.float_to_modbus_lsw(values, 0, Params.SteinHart_C);
                                reply = this.fapp.modbus_write_multiple_register(36, values);
                                if (reply != null) {
                                    values = new int[2];
                                    this.fapp.float_to_modbus_lsw(values, 0, Params.Istart);
                                    reply = this.fapp.modbus_write_multiple_register(24, values);
                                    if (reply != null && (reply = this.fapp.modbus_write_single_register(26, Params.Outstart)) != null) {
                                        values = new int[2];
                                        this.fapp.float_to_modbus_lsw(values, 0, Params.Istop);
                                        reply = this.fapp.modbus_write_multiple_register(28, values);
                                        if (reply != null && (reply = this.fapp.modbus_write_single_register(30, Params.Outstop)) != null && (reply = this.fapp.modbus_write_single_register(7, (values = new int[]{Params._FAILEEPROM * 1 + Params._INPUTOVERRANGE * 2 + Params._INPUTOVERRANGE * 4 + Params._RTDTHIRDWIREERROR * 8 + Params._RTDOUTOFTHERANGE * 16 + Params._OUTPUTOVERRANGE * 32 + Params._OUTPUTUNDERRANGE * 64})[0])) != null) {
                                            values = new int[1];
                                            reply = this.fapp.modbus_write_single_register(23, Params.alarmStatusValue);
                                            if (reply != null) {
                                                values = new int[2];
                                                this.fapp.float_to_modbus_lsw(values, 0, Params.alarmTreshold);
                                                reply = this.fapp.modbus_write_multiple_register(38, values);
                                                if (reply != null) {
                                                    values = new int[2];
                                                    this.fapp.float_to_modbus_lsw(values, 0, Params.alarmHysteresis);
                                                    reply = this.fapp.modbus_write_multiple_register(40, values);
                                                    if (reply != null && (reply = this.fapp.modbus_write_single_register(327, 49600)) != null && reply != null && (reply = this.fapp.modbus_write_single_register(327, 49568)) != null) {
                                                        ok = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object[] options3 = new Object[]{FacileParam.loadLanguage("btnContinue")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("setConf"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options3, options3[0]);
            reply = this.fapp.modbus_write_single_register(327, 49568);
        } else {
            this.fapp.modbus_close();
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("setConfErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }

    private boolean readCfgFromDev() {
        boolean ok = false;
        int[] valuesComm = null;
        int[] valuesGISettings = null;
        int[] valuesCISettings = null;
        int[] valuesRTDIS = null;
        int[] valuesOUTRSettings = null;
        int[] valuesAlarmSetting = null;
        int[] valuesAlarmSetting2 = null;
        if (this.fapp.modbus_open()) {
            valuesComm = this.fapp.modbus_read_holding_register(2, 4);
            if (valuesComm != null) {
                Params.mbAddr = valuesComm[0];
                Params.mbDelay = valuesComm[1];
                Params.mbBaud = valuesComm[2];
                Params.mbParity = valuesComm[3];
            }
            if ((valuesGISettings = this.fapp.modbus_read_holding_register(6, 1)) != null) {
                Params.energySaving = (valuesGISettings[0] & 1) / 1;
                Params.measChannel = (valuesGISettings[0] & 6) / 2;
                Params.PT100meas = (valuesGISettings[0] & 8) / 8;
                Params.outputType = (valuesGISettings[0] & 0x10) / 16;
                Params.outputMeasRetrans = (valuesGISettings[0] & 0x60) / 32;
                Params.FFTrepres = (valuesGISettings[0] & 0x80) / 128;
                Params.THDcalc = (valuesGISettings[0] & 0x100) / 256;
                Params.tempSensor = (valuesGISettings[0] & 0x600) / 512;
                Params.measType = (valuesGISettings[0] & 0x1800) / 2048;
                Params.integrator = (valuesGISettings[0] & 0x2000) / 8192;
                Params.digitalOutput = (valuesGISettings[0] & 0x4000) / 16384;
                Params.filteredMeasurement = (valuesGISettings[0] & 0x8000) / 32768;
            }
            if ((valuesCISettings = this.fapp.modbus_read_holding_register(8, 15)) != null) {
                Params.transdRatio = this.fapp.modbus_lsw_to_float(valuesCISettings, 0);
                Params.minimumCurrentStartup = this.fapp.modbus_lsw_to_float(valuesCISettings, 2);
                Params.filtDC = valuesCISettings[4];
                Params.numOfZX = valuesCISettings[5];
                Params.secMeanRMS = valuesCISettings[6];
                Params.secMaxRMS = valuesCISettings[7];
                Params.secMinRMS = valuesCISettings[8];
                Params.secMeanDC = valuesCISettings[9];
                Params.secMaxDC = valuesCISettings[10];
                Params.secMinDC = valuesCISettings[11];
                Params.secMeanAC = valuesCISettings[12];
                Params.secMaxAC = valuesCISettings[13];
                Params.secMinAC = valuesCISettings[14];
            }
            if ((valuesRTDIS = this.fapp.modbus_read_holding_register(32, 6)) != null) {
                Params.SteinHart_A = this.fapp.modbus_lsw_to_float(valuesRTDIS, 0);
                Params.SteinHart_B = this.fapp.modbus_lsw_to_float(valuesRTDIS, 2);
                Params.SteinHart_C = this.fapp.modbus_lsw_to_float(valuesRTDIS, 4);
            }
            if ((valuesOUTRSettings = this.fapp.modbus_read_holding_register(23, 9)) != null) {
                int _alarmStatusValue = valuesOUTRSettings[0];
                int _t = 0;
                int i = 0;
                while (i <= Params.alarmStatus.length - 1) {
                    if (Params.alarmStatus[i] == _alarmStatusValue) break;
                    ++_t;
                    ++i;
                }
                Params.alarmStatusValue = valuesOUTRSettings[0];
                Params.Istart = this.fapp.modbus_lsw_to_float(valuesOUTRSettings, 1);
                Params.Outstart = valuesOUTRSettings[3];
                Params.Istop = this.fapp.modbus_lsw_to_float(valuesOUTRSettings, 5);
                Params.Outstop = valuesOUTRSettings[7];
                valuesOUTRSettings = this.fapp.modbus_read_holding_register(23, 9);
            }
            if ((valuesAlarmSetting = this.fapp.modbus_read_holding_register(7, 1)) != null) {
                Params._FAILEEPROM = (valuesAlarmSetting[0] & 1) / 1;
                Params._INPUTOVERRANGE = (valuesAlarmSetting[0] & 2) / 2;
                Params._INPUTUNDERRANGE = (valuesAlarmSetting[0] & 4) / 4;
                Params._RTDTHIRDWIREERROR = (valuesAlarmSetting[0] & 8) / 8;
                Params._RTDOUTOFTHERANGE = (valuesAlarmSetting[0] & 0x10) / 16;
                Params._OUTPUTOVERRANGE = (valuesAlarmSetting[0] & 0x20) / 32;
                Params._OUTPUTUNDERRANGE = (valuesAlarmSetting[0] & 0x40) / 64;
            }
            if ((valuesAlarmSetting2 = this.fapp.modbus_read_holding_register(38, 4)) != null) {
                Params.alarmTreshold = this.fapp.modbus_lsw_to_float(valuesAlarmSetting2, 0);
                Params.alarmHysteresis = this.fapp.modbus_lsw_to_float(valuesAlarmSetting2, 2);
            }
            System.out.println("Trans ratio: " + Params.secMinAC);
            System.out.println("Energy saving: " + Params.energySaving);
            System.out.println("Baud rate: " + Params.mbBaud);
            System.out.println("Parity = " + Params.mbParity);
        }
        if (valuesGISettings != null && valuesCISettings != null && valuesOUTRSettings != null && valuesRTDIS != null) {
            ok = true;
        }
        return ok;
    }

    private void saveSettingsFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showSaveDialog(this.frmFacileWinEN) == 0) {
            String extension;
            File fn = f.getSelectedFile();
            String path = fn.getAbsolutePath();
            if (!path.endsWith(extension = ".TXT")) {
                fn = new File(String.valueOf(path) + extension);
            }
            Object[] options3 = new Object[]{"CONTINUE"};
            boolean toSave = false;
            if (fn.exists()) {
                Object[] options2 = new Object[]{FacileParam.loadLanguage("msgBoxBtnOK"), FacileParam.loadLanguage("msgBoxBtnCancel")};
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxSaveSettings"), FacileParam.loadLanguage("APPNAME"), 0, 2, null, options2, options2[1]);
                if (n == 0) {
                    toSave = true;
                }
            } else {
                toSave = true;
            }
            if (toSave && !this.fapp.saveCfg(fn.getAbsolutePath())) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxSaveSettingErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
            }
        }
    }

    private void loadSettingsFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
            File fn = f.getSelectedFile();
            Object[] options3 = new Object[]{"Load file"};
            if (fn.isFile() && fn.exists()) {
                if (this.fapp.loadCfg(fn.getAbsolutePath())) {
                    this.setSettingsPage();
                } else {
                    int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxLoadSettingErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
                }
                return;
            }
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxLoadSettingNotExist"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
        }
    }

    private void exitFromApp() {
        Object[] options = new Object[]{FacileParam.loadLanguage("msgBoxBtnYES"), FacileParam.loadLanguage("msgBoxBtnNO")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxExitAPP"), FacileParam.loadLanguage("APPNAME"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
        } else if (n == 1) {
            this.frmFacileWinEN.setDefaultCloseOperation(0);
        }
    }
}

