/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class FacileParam {
    public int mbAddr;
    public int mbBaud;
    public int mbParity;
    public int mbDelay;
    public int energySaving;
    public int measChannel;
    public int PT100meas;
    public int PT100WireType;
    public int outputType;
    public int outputMeasRetrans;
    public int FFTrepres;
    public int THDcalc;
    public int tempSensor;
    public int measType;
    public int digitalOutput;
    public float transdRatio;
    public float minimumCurrentStartup;
    public int filtDC;
    public int numOfZX;
    public int secMeanRMS;
    public int secMaxRMS;
    public int secMinRMS;
    public int secMeanDC;
    public int secMaxDC;
    public int secMinDC;
    public int secMeanAC;
    public int secMaxAC;
    public int secMinAC;
    public float SteinHart_A;
    public float SteinHart_B;
    public float SteinHart_C;
    public float Istart;
    public int Outstart;
    public float Istop;
    public int Outstop;
    public static int FW_version = -1;
    public static String MachineID_versionName = "";
    public static int MachineID_version = 0;
    public static String Machine_Title = "";
    public static String langFilePath = "";
    public static String selectedLang;

    public String getIniMBaddr() {
        return Integer.toString(this.mbAddr);
    }

    public void setIniMBaddr(String s) {
        try {
            this.mbAddr = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBbaud() {
        return Integer.toString(this.mbBaud);
    }

    public void setIniMBbaud(String s) {
        try {
            this.mbBaud = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBparity() {
        return Integer.toString(this.mbParity);
    }

    public void setIniMBparity(String s) {
        try {
            this.mbParity = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBdelay() {
        return Integer.toString(this.mbDelay);
    }

    public void setIniMBdelay(String s) {
        try {
            this.mbDelay = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateParam() {
        if (this.mbAddr < 1 || this.mbAddr > 252) {
            this.mbAddr = 1;
        }
        if (this.mbBaud < 0 || this.mbBaud > 7) {
            this.mbBaud = 3;
        }
        if (this.mbParity < 0 || this.mbParity > 2) {
            this.mbParity = 0;
        }
        if (this.mbDelay < 1 || this.mbDelay > 65535) {
            this.mbDelay = 1;
        }
    }

    public void setFactoryDefault() {
        this.mbAddr = 1;
        this.mbBaud = 3;
        this.mbParity = 0;
        this.mbDelay = 1;
        this.energySaving = 0;
        this.measChannel = 0;
        this.PT100meas = 1;
        this.PT100WireType = 0;
        this.outputType = 1;
        this.outputMeasRetrans = 0;
        this.FFTrepres = 0;
        this.THDcalc = 0;
        this.tempSensor = 1;
        this.measType = 0;
        this.digitalOutput = 0;
        this.transdRatio = 1.0f;
        this.filtDC = 10;
        this.numOfZX = 50;
        this.secMeanAC = 0;
        this.secMaxAC = 0;
        this.secMinAC = 0;
        this.secMeanRMS = 0;
        this.secMaxRMS = 0;
        this.secMinRMS = 0;
        this.secMeanDC = 0;
        this.secMaxDC = 0;
        this.secMinDC = 0;
        this.Istart = 0.0f;
        this.Outstart = 4000;
        this.Istop = 5.0f;
        this.Outstop = 20000;
        this.SteinHart_A = 0.0f;
        this.SteinHart_B = 0.0f;
        this.SteinHart_C = 0.0f;
        this.minimumCurrentStartup = 0.0f;
    }

    public static String getFileTar(int[] v) {
        String s = " File Tar : ";
        s = String.valueOf(s) + String.format("%04d", v[0]);
        s = String.valueOf(s) + String.format("%04d", v[1]);
        s = String.valueOf(s) + String.format("%04d", v[2]);
        return s;
    }

    public static String getApplicationStartUpPath() {
        String retPath = "";
        try {
            retPath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retPath;
    }

    public static String getApplicationLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/applogo.png";
    }

    public static String getProdLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/prod.png";
    }

    public static String loadLanguage(String propertyName) {
        Properties p = new Properties();
        try {
            if (selectedLang == null) {
                selectedLang = "EN";
            }
            String tempPath = String.valueOf(FacileParam.getApplicationStartUpPath()) + "/" + selectedLang + ".lng";
            p.load(new FileInputStream(tempPath));
            return p.getProperty(propertyName).toString();
        }
        catch (Exception e) {
            System.out.println(e);
            return p.getProperty(propertyName).toString();
        }
    }

    public static ArrayList<HashMap<String, String>> getLanguageFileList() {
        ArrayList<HashMap<String, String>> languageList = new ArrayList<HashMap<String, String>>();
        File home = new File(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/");
        if (home.listFiles(new FileExtensionFilter()).length > 0) {
            File[] fileArray = home.listFiles(new FileExtensionFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                HashMap<String, String> lang = new HashMap<String, String>();
                lang.put("language", file.getName().substring(0, file.getName().length() - 4));
                lang.put("languagePath", file.getPath());
                languageList.add(lang);
                ++n2;
            }
        }
        return languageList;
    }

    public static void setLanguage(String strLang) {
        selectedLang = strLang;
    }

    static class FileExtensionFilter
    implements FilenameFilter {
        FileExtensionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".lng") || name.endsWith(".LNG");
        }
    }
}

