/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import java.util.prefs.Preferences;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class FacileApp {
    public static int FW = 2;
    private String appName = "FACILE-APP-";
    private String iniKeyLang = "LANG";
    private String iniKeymbAddr = "MBAddres";
    private String iniKeymbBaud = "MBBaudrate";
    private String iniKeymbParity = "MBParity";
    private String iniKeymbDelay = "MBDelay";
    private String iniKeyenergySaving = "ENERGYSAVING";
    private String iniKeymeasChannel = "MEASCHANNEL";
    private String iniKeyPT100meas = "PT100MEAS";
    private String iniKeyoutputType = "OUTPUTTYPE";
    private String iniKeyoutputMeasRetrans = "OUTPUTMEASRETRANSMISSION";
    private String iniKeyFFTrepres = "FFTREPRESENTATION";
    private String iniKeyTHDcalc = "THDCALC";
    private String iniKeytempSensor = "TEMPSENSOR";
    private String iniKeymeasType = "MEASTYPE";
    private String iniKeyDigitalOutput = "DIGITALOUTPUT";
    private String iniKeyIntegrator = "Integrator";
    private String iniKeyFilteredMeasurement = "FILTEREDMEASUREMENT";
    private String iniKeyIstart = "ISTART";
    private String iniKeyOutstart = "OUTSTART";
    private String iniKeyIstop = "ISTOP";
    private String iniKeyOutstop = "OUTSTOP";
    private String iniKeytransdRatio = "TRANSDUCERRATIO";
    private String iniKeyminimumCurrentStartup = "MINIMUMCURRENTSTARTUP";
    private String iniKeyfiltDC = "FILTDC";
    private String iniKeynumOfZX = "NUMOFZX";
    private String iniKeysecMeanRMS = "SECMEANRMS";
    private String iniKeysecMaxRMS = "SECMAXRMS";
    private String iniKeysecMinRMS = "SECMINRMS";
    private String iniKeysecMeanDC = "SECMEANDC";
    private String iniKeysecMaxDC = "SECMAXDC";
    private String iniKeysecMinDC = "SECMINDC";
    private String iniKeysecMeanAC = "SECMEANAC";
    private String iniKeysecMaxAC = "SECMAXAC";
    private String iniKeysecMinAC = "SECMINAC";
    private String iniKeySteinHart_A = "STEINHART_A";
    private String iniKeySteinHart_B = "STEINHART_B";
    private String iniKeySteinHart_C = "STEINHART_C";
    private String iniKey_FAILEEPROM = "FAILEPROM";
    private String iniKey_INPUTUNDERRANGE = "INPUTUNDERRANGE";
    private String iniKey_INPUTOVERRANGE = "INPUTOVERRANGE";
    private String iniKey_OUTPUTUNDERRANGE = "OUTPUTUNDERRANGE";
    private String iniKey_OUTPUTOVERRANGE = "OUTPUTOVERRANGE";
    private String iniKey_RTDOUTOFTHERANGE = "OUTOFTHERANGE";
    private String iniKey_RTDTHIRDWIREERROR = "THIRDWIREERROR";
    private String iniKey_AlarmSettings = "ALARMSETTING";
    private String iniKey_AlarmTreshold = "ALARMTRESHOLD";
    private String iniKey_AlarmHysteresis = "ALARMHYSTERESIS";
    public FacileLangEnum lang;
    public FacileParam param = new FacileParam();
    public PagesEnum ultimaPagina;
    public boolean ultimaPaginaValida;
    public boolean isOffline;
    public String comName;
    public SerialPort coms;
    public int comBaud;
    public int comParity;
    public int comStopBits;
    public int modbusAddr;
    public int modbusTmo;
    public int qiDelay;
    public int fw_read = -1;
    public int[] bauds = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private int[] paritys;

    public FacileApp() {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        this.paritys = nArray;
    }

    public boolean saveCfg(String filename) {
        try {
            Properties p = new Properties();
            p.setProperty(this.iniKeymbAddr, String.valueOf(Params.mbAddr));
            p.setProperty(this.iniKeymbBaud, String.valueOf(Params.mbBaud));
            p.setProperty(this.iniKeymbParity, String.valueOf(Params.mbParity));
            p.setProperty(this.iniKeymbDelay, String.valueOf(Params.mbDelay));
            p.setProperty(this.iniKeyenergySaving, String.valueOf(Params.energySaving));
            p.setProperty(this.iniKeymeasChannel, String.valueOf(Params.measChannel));
            p.setProperty(this.iniKeyPT100meas, String.valueOf(Params.PT100meas));
            p.setProperty(this.iniKeyoutputType, String.valueOf(Params.outputType));
            p.setProperty(this.iniKeyoutputMeasRetrans, String.valueOf(Params.outputMeasRetrans));
            p.setProperty(this.iniKeyFFTrepres, String.valueOf(Params.FFTrepres));
            p.setProperty(this.iniKeyTHDcalc, String.valueOf(Params.THDcalc));
            p.setProperty(this.iniKeytempSensor, String.valueOf(Params.tempSensor));
            p.setProperty(this.iniKeymeasType, String.valueOf(Params.measType));
            p.setProperty(this.iniKeyDigitalOutput, String.valueOf(Params.digitalOutput));
            p.setProperty(this.iniKeyIntegrator, String.valueOf(Params.integrator));
            p.setProperty(this.iniKeyFilteredMeasurement, String.valueOf(Params.filteredMeasurement));
            p.setProperty(this.iniKeyIstart, String.valueOf(Params.Istart));
            p.setProperty(this.iniKeyOutstart, String.valueOf(Params.Outstart));
            p.setProperty(this.iniKeyIstop, String.valueOf(Params.Istop));
            p.setProperty(this.iniKeyOutstop, String.valueOf(Params.Outstop));
            p.setProperty(this.iniKeytransdRatio, String.valueOf(Params.transdRatio));
            p.setProperty(this.iniKeyminimumCurrentStartup, String.valueOf(Params.minimumCurrentStartup));
            p.setProperty(this.iniKeyfiltDC, String.valueOf(Params.filtDC));
            p.setProperty(this.iniKeynumOfZX, String.valueOf(Params.numOfZX));
            p.setProperty(this.iniKeysecMeanRMS, String.valueOf(Params.secMeanRMS));
            p.setProperty(this.iniKeysecMaxRMS, String.valueOf(Params.secMaxRMS));
            p.setProperty(this.iniKeysecMinRMS, String.valueOf(Params.secMinRMS));
            p.setProperty(this.iniKeysecMeanDC, String.valueOf(Params.secMeanDC));
            p.setProperty(this.iniKeysecMaxDC, String.valueOf(Params.secMaxDC));
            p.setProperty(this.iniKeysecMinDC, String.valueOf(Params.secMinDC));
            p.setProperty(this.iniKeysecMeanAC, String.valueOf(Params.secMeanAC));
            p.setProperty(this.iniKeysecMaxAC, String.valueOf(Params.secMaxAC));
            p.setProperty(this.iniKeysecMinAC, String.valueOf(Params.secMinAC));
            p.setProperty(this.iniKeySteinHart_A, String.valueOf(Params.SteinHart_A));
            p.setProperty(this.iniKeySteinHart_B, String.valueOf(Params.SteinHart_B));
            p.setProperty(this.iniKeySteinHart_C, String.valueOf(Params.SteinHart_C));
            p.setProperty(this.iniKey_FAILEEPROM, String.valueOf(Params._FAILEEPROM));
            p.setProperty(this.iniKey_INPUTOVERRANGE, String.valueOf(Params._INPUTOVERRANGE));
            p.setProperty(this.iniKey_INPUTUNDERRANGE, String.valueOf(Params._INPUTUNDERRANGE));
            p.setProperty(this.iniKey_OUTPUTOVERRANGE, String.valueOf(Params._OUTPUTOVERRANGE));
            p.setProperty(this.iniKey_OUTPUTUNDERRANGE, String.valueOf(Params._OUTPUTUNDERRANGE));
            p.setProperty(this.iniKey_RTDOUTOFTHERANGE, String.valueOf(Params._RTDOUTOFTHERANGE));
            p.setProperty(this.iniKey_RTDTHIRDWIREERROR, String.valueOf(Params._RTDTHIRDWIREERROR));
            p.setProperty(this.iniKey_AlarmSettings, String.valueOf(Params.alarmStatusValue));
            p.setProperty(this.iniKey_AlarmTreshold, String.valueOf(Params.alarmTreshold));
            p.setProperty(this.iniKey_AlarmHysteresis, String.valueOf(Params.alarmHysteresis));
            p.store(new FileOutputStream(filename), "");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage().toString());
            return false;
        }
        return true;
    }

    public boolean loadCfg(String filename) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(filename));
            Params.mbAddr = Integer.valueOf(p.getProperty(this.iniKeymbAddr));
            Params.mbBaud = Integer.valueOf(p.getProperty(this.iniKeymbBaud));
            Params.mbParity = Integer.valueOf(p.getProperty(this.iniKeymbParity));
            Params.mbDelay = Integer.valueOf(p.getProperty(this.iniKeymbDelay));
            Params.energySaving = Integer.valueOf(p.getProperty(this.iniKeyenergySaving));
            Params.measChannel = Integer.valueOf(p.getProperty(this.iniKeymeasChannel));
            Params.PT100meas = Integer.valueOf(p.getProperty(this.iniKeyPT100meas));
            Params.outputType = Integer.valueOf(p.getProperty(this.iniKeyoutputType));
            Params.outputMeasRetrans = Integer.valueOf(p.getProperty(this.iniKeyoutputMeasRetrans));
            Params.FFTrepres = Integer.valueOf(p.getProperty(this.iniKeyFFTrepres));
            Params.THDcalc = Integer.valueOf(p.getProperty(this.iniKeyTHDcalc));
            Params.tempSensor = Integer.valueOf(p.getProperty(this.iniKeytempSensor));
            Params.measType = Integer.valueOf(p.getProperty(this.iniKeymeasType));
            Params.integrator = Integer.valueOf(p.getProperty(this.iniKeyIntegrator));
            Params.filteredMeasurement = Integer.valueOf(p.getProperty(this.iniKeyFilteredMeasurement));
            Params.Istart = Float.valueOf(p.getProperty(this.iniKeyIstart)).floatValue();
            Params.Outstart = Integer.valueOf(p.getProperty(this.iniKeyOutstart));
            Params.Istop = Float.valueOf(p.getProperty(this.iniKeyIstop)).floatValue();
            Params.Outstop = Integer.valueOf(p.getProperty(this.iniKeyOutstop));
            Params.transdRatio = Float.valueOf(p.getProperty(this.iniKeytransdRatio)).floatValue();
            Params.minimumCurrentStartup = Float.valueOf(p.getProperty(this.iniKeyminimumCurrentStartup)).floatValue();
            Params.filtDC = Integer.valueOf(p.getProperty(this.iniKeyfiltDC));
            Params.numOfZX = Integer.valueOf(p.getProperty(this.iniKeynumOfZX));
            Params.secMeanRMS = Integer.valueOf(p.getProperty(this.iniKeysecMeanRMS));
            Params.secMaxRMS = Integer.valueOf(p.getProperty(this.iniKeysecMaxRMS));
            Params.secMinRMS = Integer.valueOf(p.getProperty(this.iniKeysecMinRMS));
            Params.secMeanDC = Integer.valueOf(p.getProperty(this.iniKeysecMeanDC));
            Params.secMaxDC = Integer.valueOf(p.getProperty(this.iniKeysecMaxDC));
            Params.secMinDC = Integer.valueOf(p.getProperty(this.iniKeysecMinDC));
            Params.secMeanAC = Integer.valueOf(p.getProperty(this.iniKeysecMeanAC));
            Params.secMaxAC = Integer.valueOf(p.getProperty(this.iniKeysecMaxAC));
            Params.secMinAC = Integer.valueOf(p.getProperty(this.iniKeysecMinAC));
            Params.SteinHart_A = Float.valueOf(p.getProperty(this.iniKeySteinHart_A)).floatValue();
            Params.SteinHart_B = Float.valueOf(p.getProperty(this.iniKeySteinHart_B)).floatValue();
            Params.SteinHart_C = Float.valueOf(p.getProperty(this.iniKeySteinHart_C)).floatValue();
            Params._FAILEEPROM = Integer.valueOf(p.getProperty(this.iniKey_FAILEEPROM));
            Params._INPUTOVERRANGE = Integer.valueOf(p.getProperty(this.iniKey_INPUTOVERRANGE));
            Params._INPUTUNDERRANGE = Integer.valueOf(p.getProperty(this.iniKey_INPUTUNDERRANGE));
            Params._OUTPUTOVERRANGE = Integer.valueOf(p.getProperty(this.iniKey_OUTPUTOVERRANGE));
            Params._OUTPUTUNDERRANGE = Integer.valueOf(p.getProperty(this.iniKey_OUTPUTUNDERRANGE));
            Params._RTDOUTOFTHERANGE = Integer.valueOf(p.getProperty(this.iniKey_RTDOUTOFTHERANGE));
            Params._RTDTHIRDWIREERROR = Integer.valueOf(p.getProperty(this.iniKey_RTDTHIRDWIREERROR));
            Params.alarmStatusValue = Integer.valueOf(p.getProperty(this.iniKey_AlarmSettings));
            Params.alarmHysteresis = Float.valueOf(p.getProperty(this.iniKey_AlarmHysteresis)).floatValue();
            Params.alarmTreshold = Float.valueOf(p.getProperty(this.iniKey_AlarmTreshold)).floatValue();
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void loadAppIni() {
        Preferences root = Preferences.userRoot();
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "current.ini");
        String content = "";
        this.lang = FacileLangEnum.FacileLangEN;
        try {
            FileReader reader = new FileReader(f2);
            char[] chars = new char[(int)f2.length()];
            reader.read(chars);
            content = new String(chars);
            reader.close();
            FacileParam.setLanguage(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveAppIni();
    }

    public void saveAppIni() {
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "current.ini");
        try {
            FileWriter writer = new FileWriter(f2);
            if (FacileParam.selectedLang == null) {
                FacileParam.selectedLang = "EN";
            }
            writer.write(FacileParam.selectedLang.toString());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String[] facileGetCommPorts() {
        return SerialPortList.getPortNames();
    }

    public int getFW() {
        int _fw = 2;
        int[] rsp = this.modbus_read_holding_register(0, 2);
        if (rsp != null) {
            this.modbus_close();
            if (rsp[0] == 15 || rsp[0] == 25) {
                _fw = rsp[1] % 256;
            }
        }
        return _fw;
    }

    public boolean checkConnected(String com) {
        boolean st = false;
        this.comName = com;
        this.isOffline = false;
        if (this.modbus_open()) {
            int[] rsp = this.modbus_read_holding_register(0, 2);
            if (rsp != null) {
                this.modbus_close();
                if (rsp[0] == 15 || rsp[0] == 25) {
                    int _hw = rsp[1] / 256;
                    int _fw = rsp[1] % 256;
                    System.out.println("HW ver.:" + _hw);
                    System.out.println("FW ver.:" + _fw);
                    int _firmwareVer1 = _fw / 100;
                    int _firmwareVer2 = _fw % 100 / 10;
                    int _firmwareVer3 = _fw % 100 % 10;
                    Params.machineID = rsp[0];
                    Params.appFirmware = String.format("FW: %d.%d.%d", _firmwareVer1, _firmwareVer2, _firmwareVer3);
                    this.fw_read = _fw;
                    FW = _fw;
                } else {
                    this.fw_read = -1;
                }
                return true;
            }
            this.modbus_close();
            return false;
        }
        this.modbus_close();
        return false;
    }

    public String getStopBitsString() {
        if (this.comStopBits == 0) {
            return "1";
        }
        return "2";
    }

    private byte[] CRC_16(byte[] pbytModbus) {
        byte[] crc = new byte[2];
        int intLength = pbytModbus.length - 2;
        int lngCRC = 65535;
        int lngGenerator = 40961;
        int intI = 0;
        while (intI < intLength) {
            byte temp = pbytModbus[intI];
            lngCRC ^= temp & 0xFF;
            int intJ = 0;
            while (intJ < 8) {
                boolean blnBit = (lngCRC & 1) != 0;
                lngCRC >>>= 1;
                if (blnBit) {
                    lngCRC ^= 0xA001;
                }
                ++intJ;
            }
            ++intI;
        }
        crc[0] = (byte)(lngCRC & 0xFF);
        crc[1] = (byte)(lngCRC >> 8);
        return crc;
    }

    private void add_CRC_16(byte[] pbytModbus) {
        int intLength = pbytModbus.length - 2;
        byte[] crc = this.CRC_16(pbytModbus);
        pbytModbus[intLength++] = crc[0];
        pbytModbus[intLength] = crc[1];
    }

    private boolean Check_CRC(byte[] pbytModbus) {
        byte[] crc = this.CRC_16(pbytModbus);
        return crc[0] == pbytModbus[pbytModbus.length - 2] && crc[1] == pbytModbus[pbytModbus.length - 1];
    }

    private byte intToByte(int v) {
        byte b;
        if (v > 127) {
            b = (byte)v;
            b = (byte)(b + 256);
        } else {
            b = (byte)v;
        }
        return b;
    }

    public byte[] Read_Holding_Registers(int addr, int startRegister, int nRegister) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 3;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = 0;
        bytMessaggio[5] = (byte)nRegister;
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Single_Register(int addr, int Register, int Value) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 6;
        bytMessaggio[2] = (byte)(Register >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(Register & 0xFF);
        bytMessaggio[4] = (byte)(Value >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(Value & 0xFF);
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Multiple_Register(int addr, int startRegister, int[] values) {
        byte[] bytMessaggio = new byte[9 + values.length * 2];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 16;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = (byte)(values.length >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(values.length & 0xFF);
        bytMessaggio[6] = (byte)(values.length * 2);
        int i = 0;
        while (i < values.length) {
            bytMessaggio[7 + i * 2] = (byte)(values[i] >> 8 & 0xFF);
            bytMessaggio[8 + i * 2] = (byte)(values[i] & 0xFF);
            ++i;
        }
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    public boolean modbus_open() {
        try {
            if (this.coms != null && this.coms.isOpened()) {
                this.coms.purgePort(1);
                this.coms.purgePort(2);
                this.coms.closePort();
            }
            this.coms = new SerialPort(this.comName);
            this.coms.openPort();
            this.coms.setParams(this.bauds[this.comBaud], 8, 1, this.paritys[this.comParity]);
            this.coms.setFlowControlMode(0);
            this.modbus_setTimeout();
        }
        catch (Exception e) {
            System.out.println("MODBUS-PORT error: " + e.getMessage());
            this.modbus_close();
            try {
                this.coms.closePort();
            }
            catch (SerialPortException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void modbus_close() {
        try {
            this.coms.purgePort(1);
            this.coms.purgePort(2);
            this.coms.closePort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] modbus_send_request(byte[] req, int tmo) {
        byte[] rsp = new byte[1024];
        byte[] rsp2 = new byte[1024];
        try {
            int i;
            this.coms.writeBytes(req);
            boolean nonarrivato = true;
            int tmocnt = 0;
            int len = 0;
            while (nonarrivato) {
                Thread.sleep(50L);
                rsp2 = this.coms.readBytes();
                int len2 = rsp2 != null ? rsp2.length : 0;
                if (len2 > 0) {
                    tmocnt = 0;
                    i = 0;
                    int j = len;
                    while (i < len2) {
                        if (j < 1024) {
                            rsp[j] = rsp2[i];
                        }
                        ++i;
                        ++j;
                    }
                    len = j;
                    continue;
                }
                if (len > 0) {
                    nonarrivato = false;
                    continue;
                }
                if ((tmocnt += 50) < tmo) continue;
                nonarrivato = false;
            }
            byte[] rspf = null;
            if (len > 0) {
                rspf = new byte[len];
                i = 0;
                while (i < len) {
                    rspf[i] = rsp[i];
                    ++i;
                }
            }
            return rspf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean modbus_check_valid_rsp(byte[] rsp, int addr) {
        int len = rsp.length;
        return len > 4 && rsp[0] == (byte)addr && this.Check_CRC(rsp);
    }

    public int[] modbus_read_holding_register(int startReg, int nRegs) {
        byte[] rsp = null;
        int[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new int[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public int modbus_read_holding_register_single_value(int startReg, int nRegs) {
        int i = 1;
        byte[] rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            int rhr_rsp = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
            return rhr_rsp;
        }
        return -1;
    }

    public long[] modbus_read_holding_register_with_harmonics(int startReg, int nRegs) {
        byte[] rsp = null;
        long[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new long[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = ((long)rsp[3 + 2 * i] & 0xFFL) * 256L + ((long)rsp[4 + 2 * i] & 0xFFL);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public byte[] modbus_write_single_register(int startReg, int value) {
        byte[] rsp = null;
        byte[] req = this.Write_Single_Register(this.modbusAddr, startReg, value);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public byte[] modbus_write_multiple_register(int startReg, int[] values) {
        byte[] rsp = null;
        byte[] req = this.Write_Multiple_Register(this.modbusAddr, startReg, values);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public void float_to_modbus_msw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos] = (bits & 0xFFFF0000) >>> 16;
        buf[pos + 1] = bits & 0xFFFF;
    }

    public void float_to_modbus_lsw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos + 1] = (bits & 0xFFFF0000) >>> 16;
        buf[pos] = bits & 0xFFFF;
    }

    public float modbus_msw_to_float(int[] buf, int pos) {
        int bits = buf[pos] << 16;
        return Float.intBitsToFloat(bits += buf[pos + 1]);
    }

    public float modbus_lsw_to_float(int[] buf, int pos) {
        int bits = buf[pos + 1] << 16;
        return Float.intBitsToFloat(bits += buf[pos]);
    }

    public int uint16_to_sint16(int u) {
        int s = u > Short.MAX_VALUE ? u - 65536 : u;
        return s;
    }

    public int sint16_to_uint16(int s) {
        int u = s < 0 ? s + 65536 : s;
        return u;
    }

    public int float_to_int(float f) {
        int n = Math.round(f);
        return n;
    }

    private void modbus_setTimeout() {
        this.modbusTmo = 1000;
    }

    public String getBaudString() {
        String s = String.format("%d", this.bauds[this.comBaud]);
        return s;
    }

    public String getParityString() {
        if (this.comParity == 0) {
            return "NO PARITY";
        }
        if (this.comParity == 1) {
            return "EVEN PARITY";
        }
        return "ODD PARITY";
    }

    public String getDelayString() {
        String s = String.format("%d", this.qiDelay);
        return s;
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                System.out.println(String.format("%d", event.getEventValue()));
            } else if (event.isCTS()) {
                if (event.getEventValue() == 1) {
                    System.out.println("CTS - ON");
                } else {
                    System.out.println("CTS - OFF");
                }
            } else if (event.isDSR()) {
                if (event.getEventValue() == 1) {
                    System.out.println("DSR - ON");
                } else {
                    System.out.println("DSR - OFF");
                }
            }
        }
    }
}

