/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class FacileParam {
    public float inSS;
    public float inSE;
    public int outSS;
    public int outSE;
    public int mbAddr;
    public int mbBaud;
    public int mbParity;
    public int mbDelay;
    public int filt;
    public int filt1;
    public int cutoff;
    public static int FW_version = -1;
    public static String MachineID_versionName = "";
    public static int MachineID_version = 0;
    public static String Machine_Title = "";
    public static String langFilePath = "";
    public static String selectedLang;

    public String getIniInSS() {
        return Float.toString(this.inSS);
    }

    public void setIniInSS(String s) {
        try {
            this.inSS = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniInSE() {
        return Float.toString(this.inSE);
    }

    public void setIniInSE(String s) {
        try {
            this.inSE = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniOutSS() {
        return Integer.toString(this.outSS);
    }

    public void setIniOutSS(String s) {
        try {
            this.outSS = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniOutSE() {
        return Integer.toString(this.outSE);
    }

    public void setIniOutSE(String s) {
        try {
            this.outSE = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBaddr() {
        return Integer.toString(this.mbAddr);
    }

    public void setIniMBaddr(String s) {
        try {
            this.mbAddr = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBbaud() {
        return Integer.toString(this.mbBaud);
    }

    public void setIniMBbaud(String s) {
        try {
            this.mbBaud = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBparity() {
        return Integer.toString(this.mbParity);
    }

    public void setIniMBparity(String s) {
        try {
            this.mbParity = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniMBdelay() {
        return Integer.toString(this.mbDelay);
    }

    public void setIniMBdelay(String s) {
        try {
            this.mbDelay = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniFilt() {
        return Integer.toString(this.filt);
    }

    public void setIniFilt(String s) {
        try {
            this.filt = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniFilt1() {
        return Integer.toString(this.filt1);
    }

    public void setIniFilt1(String s) {
        try {
            this.filt1 = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIniCutoff() {
        return Integer.toString(this.cutoff);
    }

    public void setIniCutoff(String s) {
        try {
            this.cutoff = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateParam() {
        if (MachineID_version == 4) {
            if ((double)this.inSS < -50.0 || (double)this.inSS > 50.0) {
                this.inSS = 0.0f;
            }
            if ((double)this.inSE < -50.0 || (double)this.inSE > 50.0) {
                this.inSE = 50.0f;
            }
            if (this.inSS > this.inSE) {
                this.inSS = this.inSE;
            }
        } else if (MachineID_version == 16) {
            if ((double)this.inSS < -300.0 || (double)this.inSS > 300.0) {
                this.inSS = 0.0f;
            }
            if ((double)this.inSE < -300.0 || (double)this.inSE > 300.0) {
                this.inSE = 300.0f;
            }
            if (this.inSS > this.inSE) {
                this.inSS = this.inSE;
            }
        }
        if (this.outSS < 0 || this.outSS > 10000) {
            this.outSS = 0;
        }
        if (this.outSE < 0 || this.outSE > 10000) {
            this.outSE = 0;
        }
        if (this.outSS > this.outSE) {
            this.outSS = this.outSE;
        }
        if (this.mbAddr < 1 || this.mbAddr > 252) {
            this.mbAddr = 1;
        }
        if (this.mbBaud < 0 || this.mbBaud > 7) {
            this.mbBaud = 3;
        }
        if (this.mbParity < 0 || this.mbParity > 2) {
            this.mbParity = 0;
        }
        if (this.mbDelay < 1 || this.mbDelay > 65535) {
            this.mbDelay = 1;
        }
        if (this.filt < 1000 || this.filt > 20000) {
            this.filt = 4096;
        }
        if (this.filt1 < 1 || this.filt1 > 32) {
            this.filt1 = 1;
        }
        if (this.cutoff < 0 || this.cutoff > 65535) {
            this.cutoff = 250;
        }
    }

    public void setFactoryDefault() {
        if (MachineID_version == 4) {
            this.inSS = 0.0f;
            this.inSE = 50.0f;
        } else if (MachineID_version == 16) {
            this.inSS = 0.0f;
            this.inSE = 300.0f;
        }
        this.outSS = 0;
        this.outSE = 10000;
        this.mbAddr = 1;
        this.mbBaud = 1;
        this.mbParity = 0;
        this.mbDelay = 1;
        this.filt = 4096;
        this.filt1 = 1;
        if (MachineID_version == 4) {
            this.cutoff = 250;
        } else if (MachineID_version == 16) {
            this.cutoff = 1500;
        }
    }

    public static String getFileTar(int[] v) {
        String s = " File Tar : ";
        s = String.valueOf(s) + String.format("%04d", v[0]);
        s = String.valueOf(s) + String.format("%04d", v[1]);
        s = String.valueOf(s) + String.format("%04d", v[2]);
        return s;
    }

    public static String getApplicationStartUpPath() {
        String retPath = "";
        try {
            retPath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retPath;
    }

    public static String getApplicationLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/applogo.png";
    }

    public static String loadLanguage(String propertyName) {
        Properties p = new Properties();
        try {
            if (selectedLang == null) {
                selectedLang = "EN";
            }
            String tempPath = String.valueOf(FacileParam.getApplicationStartUpPath()) + "/" + selectedLang + ".lng";
            p.load(new FileInputStream(tempPath));
            return p.getProperty(propertyName).toString();
        }
        catch (Exception e) {
            System.out.println(e);
            return p.getProperty(propertyName).toString();
        }
    }

    public static ArrayList<HashMap<String, String>> getLanguageFileList() {
        ArrayList<HashMap<String, String>> languageList = new ArrayList<HashMap<String, String>>();
        File home = new File(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/");
        if (home.listFiles(new FileExtensionFilter()).length > 0) {
            File[] fileArray = home.listFiles(new FileExtensionFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                HashMap<String, String> lang = new HashMap<String, String>();
                lang.put("language", file.getName().substring(0, file.getName().length() - 4));
                lang.put("languagePath", file.getPath());
                languageList.add(lang);
                ++n2;
            }
        }
        return languageList;
    }

    public static void setLanguage(String strLang) {
        selectedLang = strLang;
    }

    static class FileExtensionFilter
    implements FilenameFilter {
        FileExtensionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".lng") || name.endsWith(".LNG");
        }
    }
}

