/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FacileWinEN
implements FacileEventsInterface,
ActionListener {
    private FacileParam fpp;
    private JFrame frmFacileWinEN;
    private JButton btnIndietro;
    private JPanel pnlTab;
    private JButton btnAvanti;
    private JMenuBar menuBar;
    private JMenu mnAzioni;
    private JMenuItem mntmSelezioneLingua;
    private JMenuItem mntmEsci;
    private FacileIntroEN tabIntroIT;
    private FacileConnectionTypeEN tabConnectionTypeIT;
    private FacileConnectionModeEN tabConnectionModeIT;
    private FacileConnectionRicManEN tabConnectionRicManIT;
    private FacileMenuLoadTestEN tabMenuLoadTestIT;
    private FacileMenuSaveSendEN tabMenuSaveSendIT;
    private FacileCfg4EN tabCfg4IT;
    private FacileTestEN tabTestIT;
    private JButton btnHome;
    private JButton btnEsci;
    private FacilePagesEnum currPage;
    private FacileApp fapp;
    private FacileWinThreadEN fth;
    private Timer tmr;
    private boolean mbOpened = false;
    private boolean finder = false;
    private String deviceSerialNumber = "";
    public String com = "";

    public FacileWinEN(FacileApp fa, FacileWinThreadEN wth) {
        this.fapp = fa;
        this.fth = wth;
        ArrayList<HashMap<String, String>> listFiles = FacileParam.getLanguageFileList();
        this.initialize();
    }

    private void initialize() {
        this.frmFacileWinEN = new JFrame();
        ImageIcon ImageIcon2 = new ImageIcon(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/appicon.png");
        Image Image2 = ImageIcon2.getImage();
        this.frmFacileWinEN.setIconImage(Image2);
        this.frmFacileWinEN.setDefaultCloseOperation(0);
        this.frmFacileWinEN.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FacileWinEN.this.startEsci();
            }
        });
        this.frmFacileWinEN.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.finder = FacileParam.loadLanguage("machineID7").substring(0, 2).equalsIgnoreCase("6M");
        this.frmFacileWinEN.setResizable(false);
        if (this.finder) {
            this.frmFacileWinEN.setTitle("6M CONFIGURATION SOFTWARE");
        } else {
            this.frmFacileWinEN.setTitle("007 v1.4.2");
        }
        this.frmFacileWinEN.setSize(new Dimension(800, 600));
        this.frmFacileWinEN.setBounds(100, 100, 800, 600);
        this.menuBar = new JMenuBar();
        this.menuBar.setBackground(SystemColor.menu);
        this.menuBar.setFont(new Font("Segoe UI", 1, 12));
        this.frmFacileWinEN.setJMenuBar(this.menuBar);
        this.mnAzioni = new JMenu(FacileParam.loadLanguage("mnAzioni"));
        this.mnAzioni.setBackground(SystemColor.menu);
        this.mnAzioni.setFont(new Font("Segoe UI", 1, 12));
        this.menuBar.add(this.mnAzioni);
        this.mntmSelezioneLingua = new JMenuItem(FacileParam.loadLanguage("mntmSelezioneLingua"));
        this.mntmSelezioneLingua.addActionListener(this);
        this.mntmSelezioneLingua.setBackground(SystemColor.menu);
        this.mntmSelezioneLingua.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(this.mntmSelezioneLingua);
        JMenuItem mntmVerificaAggiornamento = new JMenuItem(FacileParam.loadLanguage("mntmVerificaAggiornamento"));
        mntmVerificaAggiornamento.setVisible(false);
        mntmVerificaAggiornamento.setBackground(SystemColor.menu);
        mntmVerificaAggiornamento.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(mntmVerificaAggiornamento);
        this.mntmEsci = new JMenuItem(FacileParam.loadLanguage("mntmEsci"));
        this.mntmEsci.addActionListener(this);
        this.mntmEsci.setBackground(SystemColor.menu);
        this.mntmEsci.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(this.mntmEsci);
        this.frmFacileWinEN.getContentPane().setLayout(null);
        this.pnlTab = new JPanel();
        this.pnlTab.setName("PANEL1");
        this.pnlTab.setBackground(new Color(240, 240, 240));
        this.pnlTab.setBounds(10, 11, 774, 465);
        this.frmFacileWinEN.getContentPane().add(this.pnlTab);
        this.pnlTab.setLayout(null);
        this.btnIndietro = new JButton(FacileParam.loadLanguage("btnIndietro"));
        this.btnIndietro.addActionListener(this);
        this.btnIndietro.setCursor(Cursor.getPredefinedCursor(12));
        this.btnIndietro.setBounds(258, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnIndietro);
        this.btnAvanti = new JButton(FacileParam.loadLanguage("btnAvanti"));
        this.btnAvanti.addActionListener(this);
        this.btnAvanti.setCursor(Cursor.getPredefinedCursor(12));
        this.btnAvanti.setBounds(440, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnAvanti);
        this.btnHome = new JButton(FacileParam.loadLanguage("btnHome"));
        this.btnHome.addActionListener(this);
        this.btnHome.setCursor(Cursor.getPredefinedCursor(12));
        this.btnHome.setBounds(10, 487, 163, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnHome);
        this.btnEsci = new JButton(FacileParam.loadLanguage("btnEsci"));
        this.btnEsci.addActionListener(this);
        this.btnEsci.setCursor(Cursor.getPredefinedCursor(12));
        this.btnEsci.setBounds(679, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnEsci);
        this.tabIntroIT = new FacileIntroEN();
        this.tabIntroIT.setFacileEventHandler(this);
        this.tabConnectionTypeIT = new FacileConnectionTypeEN();
        this.tabConnectionTypeIT.setFacileEventHandler(this);
        this.tabConnectionModeIT = new FacileConnectionModeEN();
        this.tabConnectionModeIT.setFacileEventHandler(this);
        this.tabConnectionRicManIT = new FacileConnectionRicManEN();
        this.tabConnectionRicManIT.setFacileEventHandler(this);
        this.tabMenuLoadTestIT = new FacileMenuLoadTestEN();
        this.tabMenuLoadTestIT.setFacileEventHandler(this);
        this.tabMenuSaveSendIT = new FacileMenuSaveSendEN();
        this.tabMenuSaveSendIT.setFacileEventHandler(this);
        this.tabCfg4IT = new FacileCfg4EN();
        this.tabCfg4IT.setFacileEventHandler(this);
        this.tabTestIT = new FacileTestEN(this.fapp, this.frmFacileWinEN);
        this.tabTestIT.getNEnergy().setModel(new SpinnerNumberModel(new Float(0.0f), null, new Float(0.0f), new Float(1.0f)));
        this.tabTestIT.getPEnergy().setModel(new SpinnerNumberModel(new Float(0.0f), new Float(0.0f), null, new Float(1.0f)));
        this.tabTestIT.setFacileEventHandler(this);
        this.fapp.isOffline = true;
        this.fapp.ultimaPaginaValida = false;
        this.tmr = new Timer(100, this);
        this.setFacilePageIntro();
    }

    public JButton getBtnNewButton() {
        return this.btnIndietro;
    }

    public JPanel getPanel() {
        return this.pnlTab;
    }

    public JButton getBtnAvanti() {
        return this.btnAvanti;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getMnFile() {
        return this.mnAzioni;
    }

    public JMenuItem getMntmSelezioneLingua() {
        return this.mntmSelezioneLingua;
    }

    public JMenuItem getMntmEsci() {
        return this.mntmEsci;
    }

    @Override
    public void executeEvent(FacileEventsEnum ev) {
        if (ev == FacileEventsEnum.FacileEvCfg) {
            this.setFacilePageConnectionType();
        } else if (ev == FacileEventsEnum.FacileEvFWupd) {
            this.setFacilePageFWupdate();
        } else if (ev == FacileEventsEnum.FacileEvUSB) {
            this.setFacilePageConnectionMode();
        } else if (ev == FacileEventsEnum.FacileEvOffline) {
            this.fapp.isOffline = true;
            this.setFacilePageMenuLoadTest();
        } else if (ev != FacileEventsEnum.FacileEvRicercaAutomatica) {
            if (ev == FacileEventsEnum.FacileEvRicercaManuale) {
                this.setFacilePageConnectionRicMan();
            } else if (ev == FacileEventsEnum.FacileEvRicercaManualeAggiorna) {
                this.aggiornaFacilePageConnectionRicMan();
            } else if (ev == FacileEventsEnum.FacileEvCfgDefault) {
                this.fapp.param.setFactoryDefault();
                this.setFacilePageCfg4();
            } else if (ev == FacileEventsEnum.FacileEvGoCfgStart) {
                this.setFacilePageMenuLoadTest();
            } else if (ev != FacileEventsEnum.FacileEvFwStart) {
                if (ev == FacileEventsEnum.FacileEvRicercaManualeStart) {
                    this.startRicercaManuale();
                } else if (ev == FacileEventsEnum.FacileEvLoadFile) {
                    this.startLoadFile();
                } else if (ev == FacileEventsEnum.FacileEvSaveFile) {
                    this.startSaveFile();
                } else if (ev == FacileEventsEnum.FacileEvSendDev) {
                    if (this.sendCfgToDev()) {
                        this.setFacilePageTest();
                    }
                } else if (ev == FacileEventsEnum.FacileEvLoadDev) {
                    if (this.readCfgFromDev()) {
                        // empty if block
                    }
                    this.setFacilePageCfg4();
                } else if (ev == FacileEventsEnum.FacileEvTest) {
                    this.setFacilePageTest();
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnHome) {
            this.endTestTimer();
            this.setFacilePageIntro();
        } else if (e.getSource() == this.btnAvanti) {
            if (this.currPage == FacilePagesEnum.FacilePageIntro) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg4) {
                this.tabCfg4IT.savePage(this.fapp.param);
                this.setFacilePageMenuSaveSend();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionMode) {
                this.fapp.isOffline = false;
                this.setFacilePageConnectionRicMan();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionRicMan) {
                this.fapp.isOffline = false;
                this.setFacilePageMenuLoadTest();
            }
        } else if (e.getSource() == this.btnIndietro) {
            if (this.currPage == FacilePagesEnum.FacilePageFWupdCfg) {
                this.setFacilePageIntro();
            } else if (this.currPage == FacilePagesEnum.FacilePageFWupdate) {
                this.setFacilePageFWupdCfg();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionType) {
                this.setFacilePageIntro();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionMode) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionRicMan) {
                this.setFacilePageConnectionMode();
            } else if (this.currPage == FacilePagesEnum.FacilePageMenuLoadTest) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg4) {
                this.tabCfg4IT.savePage(this.fapp.param);
                this.setFacilePageMenuLoadTest();
            } else if (this.currPage == FacilePagesEnum.FacilePageMenuSaveSend) {
                this.setFacilePageCfg4();
            } else if (this.currPage == FacilePagesEnum.FacilePageTest) {
                this.endTestTimer();
                this.setFacilePageMenuLoadTest();
            }
        } else if (e.getSource() == this.btnEsci) {
            this.startEsci();
        } else if (e.getSource() == this.mntmEsci) {
            this.startEsci();
        } else if (e.getSource() == this.mntmSelezioneLingua) {
            FacileLangEN fd = new FacileLangEN();
            fd.showCentered(this.frmFacileWinEN.getBounds());
            fd.setVisible(true);
            if (fd.isOk()) {
                this.endTestTimer();
                this.fapp.saveAppIni();
                this.frmFacileWinEN.setVisible(false);
                this.frmFacileWinEN.dispose();
                this.fth.ended = false;
                this.fth.changeLang = true;
            }
            fd.dispose();
        } else {
            this.tmr.stop();
            if (this.currPage == FacilePagesEnum.FacilePageTest) {
                this.readTestFromDev();
                this.tmr.start();
            }
        }
    }

    protected JButton getBtnHome() {
        return this.btnHome;
    }

    protected JButton getBtnEsci() {
        return this.btnEsci;
    }

    protected void setFacilePage(FacilePagesEnum p, Component c) {
        this.fapp.ultimaPagina = this.currPage;
        this.fapp.ultimaPaginaValida = true;
        this.currPage = p;
        this.pnlTab.removeAll();
        this.pnlTab.add(c);
        this.pnlTab.repaint();
        this.pnlTab.setVisible(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pnlTab.setVisible(true);
    }

    protected void setFacilePageIntro() {
        this.setFacilePage(FacilePagesEnum.FacilePageIntro, this.tabIntroIT);
        this.btnHome.setEnabled(false);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(false);
    }

    protected void setFacilePageFWupdCfg() {
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionType() {
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionType, this.tabConnectionTypeIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageFWupdate() {
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionMode() {
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionMode, this.tabConnectionModeIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionRicMan() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.tabConnectionRicManIT.setSerialPorts(coms);
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionRicMan, this.tabConnectionRicManIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void aggiornaFacilePageConnectionRicMan() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.tabConnectionRicManIT.setSerialPorts(coms);
    }

    protected void setFacilePageMenuLoadTest() {
        this.tabMenuLoadTestIT.setOffline(this.fapp.isOffline);
        this.setFacilePage(FacilePagesEnum.FacilePageMenuLoadTest, this.tabMenuLoadTestIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageCfg4() {
        this.tabCfg4IT.initPage(this.fapp.param);
        this.setFacilePage(FacilePagesEnum.FacilePageCfg4, this.tabCfg4IT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageMenuSaveSend() {
        this.tabCfg4IT.savePage(this.fapp.param);
        this.tabMenuSaveSendIT.setOffline(this.fapp.isOffline);
        this.setFacilePage(FacilePagesEnum.FacilePageMenuSaveSend, this.tabMenuSaveSendIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageTest() {
        this.tabTestIT.setNessunValore();
        this.tabTestIT.setPbar(10);
        this.tabTestIT.setCommString(String.format("%s Baud %s 8bit %s Stopbit", this.fapp.getBaudString(), this.fapp.getParityString(), this.fapp.getStopBitsString()));
        this.setFacilePage(FacilePagesEnum.FacilePageTest, this.tabTestIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
        this.tmr.setInitialDelay(5);
        this.tmr.setDelay(10);
        this.tmr.setRepeats(false);
        this.tmr.start();
    }

    public void facileShow() {
        this.frmFacileWinEN.setVisible(true);
    }

    public boolean isFacileShowed() {
        return this.frmFacileWinEN.isVisible();
    }

    private void startEsci() {
        Object[] options = new Object[]{FacileParam.loadLanguage("boxYesUscita"), FacileParam.loadLanguage("boxNoUscita")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextUscita"), FacileParam.loadLanguage("boxTitleUscita"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
            this.fth.changeLang = false;
        }
    }

    private void startFwUpdateUSBdisk() {
        Object[] options2;
        Object[] options = new Object[]{"SI", "ANNULLA"};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "INSERT THE USB KEY TO BE USED FOR UPDATING THE FIRMWARE", "FACILE", 0, 3, null, options, options[1]);
        if (n == 0 && (n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "ALL DATA WILL BE LOST THE USB KEY, SURE TO CONTINUE?", "FACILE", 0, 2, null, options2 = new Object[]{"CONFERMA", "ANNULLA"}, options2[1])) == 0) {
            JFileChooser f = new JFileChooser();
            f.setFileSelectionMode(0);
            f.setFileFilter(new FileNameExtensionFilter("FACILE FIRMWARE UPDATE", ".FFW"));
            f.setMultiSelectionEnabled(false);
            if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
                File fn = f.getSelectedFile();
                Object[] options3 = new Object[]{"CONTINUA"};
                if (fn.isFile() && fn.exists()) {
                    Object[] disks = new Object[]{"DISCO A", "DISCO B"};
                    String diskSel = (String)JOptionPane.showInputDialog(this.frmFacileWinEN, "SELEZIONARE IL DISCO RIMOVIBILE DA UTILIZZARE PER L'AGGIORNAMENTO FIRMWARE", "FACILE", 3, null, disks, disks[0]);
                    n = JOptionPane.showOptionDialog(this.frmFacileWinEN, String.format("SICURI DI SELEZIONARE IL DISCO %s", diskSel), "FACILE", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "CHIAVETTA USB CREATA CON SUCCESSO", "FACILE", 0, 1, null, options3, options3[0]);
                    }
                } else {
                    n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "ERRORE : IL FILE NON ESISTE", "FACILE", 0, 0, null, options3, options3[0]);
                }
            }
        }
    }

    private void startRicercaManuale() {
        Object[] options = new Object[]{FacileParam.loadLanguage("boxTextConnectedBtn")};
        this.com = this.tabConnectionRicManIT.getSelectedComPort();
        this.fapp.modbusAddr = 1;
        this.fapp.comBaud = 3;
        this.fapp.comParity = 0;
        this.fapp.comStopBits = 1;
        if (this.fapp.checkConnected(this.com)) {
            if (this.finder) {
                this.frmFacileWinEN.setTitle(String.format("6M CONFIGURATION SOFTWARE - SW: v1.4.2 FW: %d.%d.%d", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10));
            } else {
                this.frmFacileWinEN.setTitle(String.valueOf(String.format("007 v1.4.2 FW: %d.%d.%d", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10)) + " " + FacileParam.loadLanguage("MachineIDTitle") + FacileParam.MachineID_version + " " + FacileParam.loadLanguage("MachineNameTitle") + FacileParam.MachineID_versionName);
            }
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextConnected"), FacileParam.loadLanguage("boxTitleConnected"), 0, 1, null, options, options[0]);
            this.setFacilePageMenuLoadTest();
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextError"), FacileParam.loadLanguage("boxTitleError"), 0, 0, null, options, options[0]);
        }
    }

    private void startLoadFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
            File fn = f.getSelectedFile();
            Object[] options3 = new Object[]{FacileParam.loadLanguage("boxLoadFileBtnText")};
            if (fn.isFile() && fn.exists()) {
                if (this.fapp.loadCfg(fn.getAbsolutePath())) {
                    this.setFacilePageCfg4();
                } else {
                    int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxLoadFileError1"), FacileParam.loadLanguage("boxLoadFileTitle"), 0, 0, null, options3, options3[0]);
                }
                return;
            }
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxLoadFileError2"), FacileParam.loadLanguage("boxLoadFileTitle"), 0, 0, null, options3, options3[0]);
        }
    }

    private void startSaveFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showSaveDialog(this.frmFacileWinEN) == 0) {
            String extension;
            File fn = f.getSelectedFile();
            String path = fn.getAbsolutePath();
            if (!path.endsWith(extension = ".TXT")) {
                fn = new File(String.valueOf(path) + extension);
            }
            Object[] options3 = new Object[]{FacileParam.loadLanguage("boxSaveFileContinue")};
            boolean toSave = false;
            if (fn.exists()) {
                Object[] options2 = new Object[]{FacileParam.loadLanguage("boxSaveFileOK"), FacileParam.loadLanguage("boxSaveFileCancel")};
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxSaveFileQuestion"), FacileParam.loadLanguage("boxSaveFileTitle"), 0, 2, null, options2, options2[1]);
                if (n == 0) {
                    toSave = true;
                }
            } else {
                toSave = true;
            }
            if (toSave && !this.fapp.saveCfg(fn.getAbsolutePath())) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxSaveFileError"), FacileParam.loadLanguage("boxSaveFileTitle"), 0, 0, null, options3, options3[0]);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean sendCfgToDev() {
        block6: {
            ok = false;
            reply = null;
            if (!this.fapp.modbus_open() || (reply = this.fapp.modbus_write_multiple_register(2, values = new int[]{this.fapp.param.mbAddr, this.fapp.param.mbDelay})) == null) break block6;
            values[0] = this.fapp.param.mbBaud;
            values[1] = this.fapp.param.mbParity;
            reply = this.fapp.modbus_write_multiple_register(4, values);
            if (reply == null || (reply = this.fapp.modbus_write_multiple_register(6, values = new int[]{this.fapp.param.f_indc, this.fapp.param.mode + this.fapp.param.flash * 2 + this.fapp.param.currFreq * 4 + 8})) == null) break block6;
            this.fapp.float_to_modbus_lsw(values, 0, this.fapp.param.ctv);
            reply = this.fapp.modbus_write_multiple_register(8, values);
            if (reply == null) break block6;
            values = new int[2];
            this.fapp.float_to_modbus_lsw(values, 0, this.fapp.param.cti);
            reply = this.fapp.modbus_write_multiple_register(10, values);
            if (reply == null) break block6;
            values = new int[1];
            this.fapp.param;
            if (FacileParam.MachineID_version == 18) ** GOTO lbl-1000
            this.fapp.param;
            if (FacileParam.MachineID_version == 22) ** GOTO lbl-1000
            this.fapp.param;
            if (FacileParam.MachineID_version == 48) ** GOTO lbl-1000
            this.fapp.param;
            if (FacileParam.MachineID_version == 49) lbl-1000:
            // 4 sources

            {
                values[0] = FacileParam.FW_version >= 36 ? this.fapp.param.f_ivAC / 40 + this.fapp.param.sogliaPot * 256 / 40 : this.fapp.param.f_ivAC / 10 + this.fapp.param.sogliaPot * 256 / 10;
            } else {
                values[0] = FacileParam.FW_version >= 36 ? this.fapp.param.f_ivAC / 4 + this.fapp.param.sogliaPot * 256 / 4 : this.fapp.param.f_ivAC + this.fapp.param.sogliaPot * 256;
            }
            reply = this.fapp.modbus_write_single_register(12, values[0]);
            if (reply != null && reply != null && (reply = this.fapp.modbus_write_single_register(13, (values = new int[]{this.fapp.param.f_inac})[0])) != null && (reply = this.fapp.modbus_write_single_register(251, 49600)) != null) {
                ok = true;
            }
        }
        options3 = new Object[]{FacileParam.loadLanguage("boxTextConfChangeBtn")};
        if (ok) {
            n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextConfChange"), FacileParam.loadLanguage("boxTitleConfChange"), 0, 1, null, options3, options3[0]);
            reply = this.fapp.modbus_write_single_register(251, 49568);
            if (reply != null) {
                ok = true;
                this.fapp.modbus_close();
                this.fapp.modbusAddr = this.fapp.param.mbAddr;
                this.fapp.comBaud = this.fapp.param.mbBaud;
                this.fapp.comParity = this.fapp.param.mbParity;
            } else {
                ok = false;
                this.fapp.modbus_close();
                n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxErrorComm"), FacileParam.loadLanguage("boxErrorCommTitle"), 0, 0, null, options3, options3[0]);
            }
            return ok;
        }
        this.fapp.modbus_close();
        var4_5 = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextErrorConfChange"), FacileParam.loadLanguage("boxTitleConfChangeError"), 0, 0, null, options3, options3[0]);
        return ok;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readCfgFromDev() {
        block9: {
            block10: {
                ok = false;
                if (!this.fapp.modbus_open()) break block9;
                values = null;
                values = this.fapp.modbus_read_holding_register(2, 4);
                if (values == null) break block9;
                this.fapp.param.mbAddr = values[0];
                this.fapp.param.mbDelay = values[1];
                this.fapp.param.mbBaud = values[2];
                this.fapp.param.mbParity = values[3];
                values = this.fapp.modbus_read_holding_register(6, 6);
                if (values == null) break block10;
                this.fapp.param.f_indc = values[0];
                this.fapp.param.mode = values[1] & 1;
                this.fapp.param.currFreq = (values[1] & 4) / 4;
                this.fapp.param.flash = (values[1] & 2) / 2;
                this.fapp.param.ctv = this.fapp.modbus_lsw_to_float(values, 2);
                this.fapp.param.cti = this.fapp.modbus_lsw_to_float(values, 4);
                values = this.fapp.modbus_read_holding_register(12, 1);
                if (values == null) break block10;
                this.fapp.param;
                if (FacileParam.MachineID_version == 18) ** GOTO lbl-1000
                this.fapp.param;
                if (FacileParam.MachineID_version == 22) ** GOTO lbl-1000
                this.fapp.param;
                if (FacileParam.MachineID_version == 48) ** GOTO lbl-1000
                this.fapp.param;
                if (FacileParam.MachineID_version == 49) lbl-1000:
                // 4 sources

                {
                    if (FacileParam.FW_version >= 36) {
                        this.fapp.param.f_ivAC = (values[0] & 255) * 10 * 4;
                        this.fapp.param.sogliaPot = values[0] / 256 * 10 * 4;
                    } else {
                        this.fapp.param.f_ivAC = (values[0] & 255) * 10;
                        this.fapp.param.sogliaPot = values[0] / 256 * 10;
                    }
                } else if (FacileParam.FW_version >= 36) {
                    this.fapp.param.f_ivAC = (values[0] & 255) * 4;
                    this.fapp.param.sogliaPot = values[0] / 256 * 4;
                } else {
                    this.fapp.param.f_ivAC = values[0] & 255;
                    this.fapp.param.sogliaPot = values[0] / 256;
                }
                ok = true;
            }
            if ((values = this.fapp.modbus_read_holding_register(13, 1)) != null) {
                this.fapp.param.f_inac = values[0];
            }
        }
        this.fapp.modbus_close();
        options3 = new Object[]{FacileParam.loadLanguage("boxTextConfChangeBtn")};
        if (ok) {
            var3_3 = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextReadConfOK"), FacileParam.loadLanguage("boxTitleReadConfOK"), 0, 1, null, options3, options3[0]);
        } else {
            var3_4 = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextReadConfERR"), FacileParam.loadLanguage("boxTitleReadConfERR"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }

    private boolean readTestFromDev() {
        byte[] reply = null;
        boolean ok = false;
        Object[] options3 = new Object[]{"CONTINUE"};
        ok = false;
        if (this.mbOpened) {
            ok = true;
        } else if (this.fapp.modbus_open()) {
            this.mbOpened = true;
            ok = true;
        }
        if (ok) {
            int[] values1 = null;
            int[] values2 = null;
            Object values3 = null;
            Object values4 = null;
            values1 = this.fapp.modbus_read_holding_register(71, 60);
            if (values1 != null) {
                try {
                    this.tabTestIT.setNoCommunication(false);
                    this.tabTestIT.setValori(values1);
                    this.tabTestIT.avanzamento();
                    if (this.tabTestIT.getWritePending() == 1) {
                        int m = this.tabTestIT.getWriteSource();
                        float v = this.tabTestIT.getWriteValue();
                        this.tabTestIT.resetWritePending();
                        if (m == 0) {
                            this.multipleWrite(v, 100, 160, 220);
                        } else if (m == 1) {
                            this.multipleWrite(v, 98, 158, 218);
                        } else if (m == 2) {
                            this.multipleWrite(v, 104, 164, 224);
                        } else if (m == 3) {
                            this.multipleWrite(v, 102, 162, 222);
                        } else if (m == 4) {
                            this.multipleWrite(v, 108, 168, 228);
                        } else if (m == 5) {
                            this.multipleWrite(v, 106, 166, 226);
                        } else if (m == 6) {
                            this.multipleWrite(v, 112, 172, 232);
                        } else if (m == 7) {
                            this.multipleWrite(v, 110, 170, 230);
                        } else if (m == 8) {
                            this.multipleWrite(v, 116, 176, 236);
                        } else if (m == 9) {
                            this.multipleWrite(v, 114, 174, 234);
                        } else if (m == 10) {
                            this.multipleWrite(v, 120, 180, 240);
                        } else if (m == 11) {
                            this.multipleWrite(v, 118, 178, 238);
                        } else if (m == 12) {
                            this.multipleWrite(v, 124, 184, 244);
                        } else if (m == 13) {
                            this.multipleWrite(v, 122, 182, 242);
                        } else if (m == 14) {
                            this.multipleWrite(v, 94, 154, 214);
                        } else if (m == 15) {
                            this.multipleWrite(v, 96, 156, 216);
                        } else if (m == 16) {
                            int[] regs = new int[2];
                            this.fapp.float_to_modbus_lsw(regs, 0, ((Float)this.tabTestIT.getEnergy().getValue()).floatValue());
                            reply = this.fapp.modbus_write_multiple_register(252, regs);
                            reply = this.fapp.modbus_write_single_register(251, 47802);
                        } else if (m == 17) {
                            int[] regs = new int[2];
                            this.fapp.float_to_modbus_lsw(regs, 0, ((Float)this.tabTestIT.getPEnergy().getValue()).floatValue());
                            reply = this.fapp.modbus_write_multiple_register(252, regs);
                            reply = this.fapp.modbus_write_single_register(251, 47803);
                        } else if (m == 18) {
                            int[] regs = new int[2];
                            this.fapp.float_to_modbus_lsw(regs, 0, ((Float)this.tabTestIT.getNEnergy().getValue()).floatValue());
                            reply = this.fapp.modbus_write_multiple_register(252, regs);
                            reply = this.fapp.modbus_write_single_register(251, 47804);
                        } else if (m == 19) {
                            this.multipleWrite(v, 128, 188, 248);
                        } else if (m == 20) {
                            this.multipleWrite(v, 126, 186, 246);
                        }
                        ok = reply != null;
                    } else {
                        ok = true;
                    }
                }
                catch (Exception m) {
                    // empty catch block
                }
            }
            if (FacileParam.FW_version != -1 && FacileParam.FW_version % 100 / 10 >= 2) {
                values2 = this.fapp.modbus_read_holding_register(40, 1);
                String serialNumber = "";
                if (values2 != null) {
                    serialNumber = String.valueOf(serialNumber) + Integer.toHexString(values2[0]);
                    values2 = this.fapp.modbus_read_holding_register(49, 1);
                    if (values2 != null) {
                        serialNumber = String.valueOf(serialNumber) + Integer.toHexString(values2[0]);
                        values2 = this.fapp.modbus_read_holding_register(56, 1);
                        if (values2 != null) {
                            serialNumber = String.valueOf(serialNumber) + Integer.toHexString(values2[0]);
                            this.tabTestIT.addCommString(" File Tar: " + serialNumber);
                        }
                    }
                }
            }
        }
        if (!ok) {
            this.tabTestIT.setNoCommunication(true);
        }
        return ok;
    }

    private void endTestTimer() {
        this.tmr.stop();
        if (this.mbOpened) {
            this.fapp.modbus_close();
            this.mbOpened = false;
        }
    }

    private void multipleWrite(float v, int regdir, int regswp, int reg100) {
        int[] values = new int[2];
        this.fapp.float_to_modbus_lsw(values, 0, v);
        byte[] reply = this.fapp.modbus_write_multiple_register(regdir, values);
        this.fapp.float_to_modbus_msw(values, 0, v);
        reply = this.fapp.modbus_write_multiple_register(regswp, values);
        int v100 = (int)((double)v * 100.0);
        values[0] = v100 % 65536;
        values[1] = v100 / 65536;
        reply = this.fapp.modbus_write_multiple_register(reg100, values);
    }

    public String getsetSerialNum(String sernum) {
        return sernum;
    }

    public void resetTitle() {
        if (this.finder) {
            this.frmFacileWinEN.setTitle(String.format("6M CONFIGURATION SOFTWARE - SW: v1.4.2 FW: %d.%d.%d", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10));
        } else {
            this.frmFacileWinEN.setTitle(String.valueOf(String.format("007 v1.4.2 FW: %d.%d.%d", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10)) + " " + FacileParam.loadLanguage("MachineIDTitle") + FacileParam.MachineID_version + " " + FacileParam.loadLanguage("MachineNameTitle") + FacileParam.MachineID_versionName);
        }
    }
}

