/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class FacileParam {
    public int mode;
    public int avg;
    public int flash;
    public int currFreq;
    public float ctv;
    public float cti;
    public int mbAddr;
    public int mbBaud;
    public int mbParity;
    public int mbDelay;
    public int f_indc;
    public int f_inac;
    public int f_ivAC;
    public int sogliaPot;
    public int[] f_indc_cmb = new int[]{1, 5, 10, 25, 50};
    public static int FW_version = -1;
    public static String MachineID_versionName = "";
    public static int MachineID_version = 0;
    public static String langFilePath = "";
    public static String selectedLang;

    public String getIniFloat(float f) {
        return Float.toString(f);
    }

    public float setIniFloat(String s) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public String getIniInteger(int s) {
        return Integer.toString(s);
    }

    public int setIniInteger(String s) {
        int f = 0;
        try {
            f = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public String getIniBoolean(boolean s) {
        return Boolean.toString(s);
    }

    public boolean setIniBoolean(String s) {
        boolean f = false;
        try {
            f = Boolean.parseBoolean(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public int forceIntParam(int v, int min, int max, int vdef) {
        int w = v;
        if (v < min || v > max) {
            w = vdef;
        }
        return w;
    }

    public float forceFloatParam(float v, float min, float max, float vdef) {
        float w = v;
        if (v < min || v > max) {
            w = vdef;
        }
        return w;
    }

    public String forceStringLen(String s, int len) {
        String stmp = s;
        if (s.length() > len) {
            stmp = stmp.substring(0, len);
        }
        return stmp;
    }

    public void validateParam() {
        this.mode = this.forceIntParam(this.mode, 0, 1, 0);
        this.flash = this.forceIntParam(this.flash, 0, 1, 0);
        this.currFreq = this.forceIntParam(this.currFreq, 0, 1, 0);
        this.f_indc = this.forceIntParam(this.f_indc, 0, 65535, 5);
        this.f_inac = this.forceIntParam(this.f_inac, 0, 65535, 50);
        if (FW_version != -1) {
            if (MachineID_version == 18 || MachineID_version == 22 || MachineID_version == 48 || MachineID_version == 49) {
                if (FW_version >= 36) {
                    this.f_ivAC = this.forceIntParam(this.f_ivAC, 0, 10200, 10200);
                    this.sogliaPot = this.forceIntParam(this.sogliaPot, 0, 10200, 10200);
                } else {
                    this.f_ivAC = this.forceIntParam(this.f_ivAC, 0, 2550, 2550);
                    this.sogliaPot = this.forceIntParam(this.sogliaPot, 0, 2550, 2550);
                }
            } else if (FW_version >= 36) {
                this.f_ivAC = this.forceIntParam(this.f_ivAC, 0, 1020, 1020);
                this.sogliaPot = this.forceIntParam(this.sogliaPot, 0, 1020, 1020);
            } else {
                this.f_ivAC = this.forceIntParam(this.f_ivAC, 0, 255, 255);
                this.sogliaPot = this.forceIntParam(this.sogliaPot, 0, 255, 255);
            }
        } else {
            this.f_ivAC = this.forceIntParam(this.f_ivAC, 0, 10200, 10200);
            this.sogliaPot = this.forceIntParam(this.sogliaPot, 0, 10200, 10200);
        }
        this.mbAddr = this.forceIntParam(this.mbAddr, 1, 252, 1);
        this.mbBaud = this.forceIntParam(this.mbBaud, 0, 7, 3);
        this.mbParity = this.forceIntParam(this.mbParity, 0, 2, 0);
        this.mbDelay = this.forceIntParam(this.mbDelay, 1, 255, 1);
    }

    public void setFactoryDefault() {
        this.mode = 0;
        this.avg = 1;
        this.flash = 1;
        this.currFreq = 0;
        this.ctv = 1.0f;
        this.cti = 1.0f;
        this.f_indc = 5;
        this.f_inac = 50;
        if (MachineID_version == 18 || MachineID_version == 22 || MachineID_version == 48 || MachineID_version == 49) {
            if (FW_version >= 36) {
                this.f_ivAC = 3000;
                this.sogliaPot = 40;
            } else {
                this.f_ivAC = 1500;
                this.sogliaPot = 10;
            }
        } else if (FW_version >= 36) {
            this.f_ivAC = 500;
            this.sogliaPot = 4;
        } else {
            this.f_ivAC = 250;
            this.sogliaPot = 1;
        }
        this.mbAddr = 1;
        this.mbBaud = 3;
        this.mbParity = 0;
        this.mbDelay = 1;
    }

    public String[] getAll() {
        String[] s = new String[14];
        s[0] = this.getIniInteger(this.mode);
        s[1] = this.getIniInteger(this.avg);
        s[2] = this.getIniInteger(this.flash);
        s[3] = this.getIniFloat(this.ctv);
        s[4] = this.getIniFloat(this.cti);
        s[5] = this.getIniInteger(this.mbAddr);
        s[6] = this.getIniInteger(this.mbBaud);
        s[7] = this.getIniInteger(this.mbParity);
        s[8] = this.getIniInteger(this.mbDelay);
        s[9] = this.getIniInteger(this.currFreq);
        s[10] = this.getIniInteger(this.f_indc);
        if (FW_version != -1) {
            if (MachineID_version == 18 || MachineID_version == 22 || MachineID_version == 48 || MachineID_version == 49) {
                if (FW_version >= 36) {
                    s[11] = this.getIniInteger(this.f_ivAC / 40);
                    s[12] = this.getIniInteger(this.sogliaPot / 40);
                } else {
                    s[11] = this.getIniInteger(this.f_ivAC / 10);
                    s[12] = this.getIniInteger(this.sogliaPot / 10);
                }
            } else if (FW_version >= 36) {
                s[11] = this.getIniInteger(this.f_ivAC / 4);
                s[12] = this.getIniInteger(this.sogliaPot / 4);
            } else {
                s[11] = this.getIniInteger(this.f_ivAC);
                s[12] = this.getIniInteger(this.sogliaPot);
            }
        } else {
            s[11] = this.getIniInteger(this.f_ivAC / 4);
            s[12] = this.getIniInteger(this.sogliaPot / 4);
        }
        s[13] = this.getIniInteger(this.f_inac);
        return s;
    }

    public void setAll(String[] s) {
        this.mode = this.setIniInteger(s[0]);
        this.avg = this.setIniInteger(s[1]);
        this.flash = this.setIniInteger(s[2]);
        this.ctv = this.setIniFloat(s[3]);
        this.cti = this.setIniFloat(s[4]);
        this.mbAddr = this.setIniInteger(s[5]);
        this.mbBaud = this.setIniInteger(s[6]);
        this.mbParity = this.setIniInteger(s[7]);
        this.mbDelay = this.setIniInteger(s[8]);
        this.currFreq = this.setIniInteger(s[9]);
        this.f_indc = this.setIniInteger(s[10]);
        if (FW_version != -1) {
            if (MachineID_version == 18 || MachineID_version == 22 || MachineID_version == 48 || MachineID_version == 49) {
                if (FW_version >= 36) {
                    this.f_ivAC = this.setIniInteger(s[11]) * 40;
                    this.sogliaPot = this.setIniInteger(s[12]) * 40;
                } else {
                    this.f_ivAC = this.setIniInteger(s[11]) * 10;
                    this.sogliaPot = this.setIniInteger(s[12]) * 10;
                }
            } else if (FW_version >= 36) {
                this.f_ivAC = this.setIniInteger(s[11]) * 4;
                this.sogliaPot = this.setIniInteger(s[12]) * 4;
            } else {
                this.f_ivAC = this.setIniInteger(s[11]);
                this.sogliaPot = this.setIniInteger(s[12]);
            }
        } else {
            this.f_ivAC = this.setIniInteger(s[11]) * 40;
            this.sogliaPot = this.setIniInteger(s[12]) * 40;
        }
        this.f_inac = this.setIniInteger(s[13]);
    }

    public int getTotFilterSamples(float f) {
        f = 20000.0f / f;
        int nc = (int)((double)f / 2.0);
        return nc;
    }

    public float setTotFilterSamples(int n) {
        float f = (float)n * 2.0f;
        f = 20000.0f / f;
        return f;
    }

    public int getBooleanToInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public boolean setBooleanToInt(int v) {
        return v != 0;
    }

    public static String getFileTar(int[] v) {
        String s = " File Tar : ";
        s = String.valueOf(s) + String.format("%04d", v[0]);
        s = String.valueOf(s) + String.format("%04d", v[1]);
        s = String.valueOf(s) + String.format("%04d", v[2]);
        return s;
    }

    public static String getApplicationStartUpPath() {
        String retPath = "";
        try {
            retPath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retPath;
    }

    public static String getApplicationLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/applogo.png";
    }

    public static String getProdLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/prod.png";
    }

    public static String loadLanguage(String propertyName) {
        Properties p = new Properties();
        try {
            if (selectedLang == null) {
                selectedLang = "EN";
            }
            String tempPath = String.valueOf(FacileParam.getApplicationStartUpPath()) + "/" + selectedLang + ".lng";
            p.load(new FileInputStream(tempPath));
            return p.getProperty(propertyName).toString();
        }
        catch (Exception e) {
            System.out.println(e);
            return p.getProperty(propertyName).toString();
        }
    }

    public static ArrayList<HashMap<String, String>> getLanguageFileList() {
        ArrayList<HashMap<String, String>> languageList = new ArrayList<HashMap<String, String>>();
        File home = new File(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/");
        if (home.listFiles(new FileExtensionFilter()).length > 0) {
            File[] fileArray = home.listFiles(new FileExtensionFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                HashMap<String, String> lang = new HashMap<String, String>();
                lang.put("language", file.getName().substring(0, file.getName().length() - 4));
                lang.put("languagePath", file.getPath());
                languageList.add(lang);
                ++n2;
            }
        }
        return languageList;
    }

    public static void setLanguage(String strLang) {
        selectedLang = strLang;
    }

    static class FileExtensionFilter
    implements FilenameFilter {
        FileExtensionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".lng") || name.endsWith(".LNG");
        }
    }
}

